package com.cusc.map.ui

import android.content.Context
import android.util.AttributeSet
import android.view.LayoutInflater
import android.widget.LinearLayout
import androidx.core.content.withStyledAttributes
import androidx.fragment.app.FragmentActivity
import com.cusc.map.MAP_TYPE
import com.cusc.map.MSDKInitializer
import com.cusc.map.R
import com.cusc.map.databinding.MultiViewBinding
import com.cusc.map.fragments.AMapFragment
import com.cusc.map.fragments.ForeMapFragment
import com.cusc.map.fragments.PartRoadFragment
import com.cusc.map.fragments.UnityFragment

/**多底图容器**/
class MapMultiView : LinearLayout {

    constructor(context: Context?) : super(context) {
        init(null, 0)
    }

    constructor(context: Context?, attrs: AttributeSet?) : super(context, attrs) {
        init(attrs, 0)
    }

    constructor(context: Context?, attrs: AttributeSet?, defStyleAttr: Int) : super(
        context,
        attrs,
        defStyleAttr
    ) {
        init(attrs, defStyleAttr)
    }

    /**地图准备就绪监听回调****/
    interface OnMapReadyLis {
        /**底图加载完成回调***/
        fun onMapReady(mapReadyView: MapReadyView)
    }

    private lateinit var binding: MultiViewBinding

    //四维在线地图
    private val foreMapFragment by lazy { ForeMapFragment.newInstance() }

    //四维高精地图
    private val unityFragment by lazy { UnityFragment.newInstance() }

    //四维局部地图
    private val partRoadFragment by lazy { PartRoadFragment.newInstance() }

    //高德地图
    private val aMapFragment by lazy { AMapFragment.newInstance() }

    //地图类型
    private var mapType = -1

    //地图子类型（高精或局部）
    private var childType = -1

    private fun init(attrs: AttributeSet?, defStyle: Int) {
        context.withStyledAttributes(attrs, R.styleable.MapMultiView, defStyle, 0) {
            if (hasValue(R.styleable.MapMultiView_map_child_type)) {
                childType = getInt(R.styleable.MapMultiView_map_child_type, -1)
            }
        }
        mapType = MSDKInitializer.getMapType().ordinal
//        println("------------MapMultiView = ${MSDKInitializer.getMapType().ordinal}")
//        println("------------enmuValue = $enmuValue")
        binding = MultiViewBinding.inflate(LayoutInflater.from(context))
        addView(binding.root)
        loadMapFrament()
    }


    private fun loadMapFrament() {
        if (context is FragmentActivity) {
            var act = context as FragmentActivity
            var ft = act.supportFragmentManager.beginTransaction()
            if (mapType == MAP_TYPE.MINE.ordinal) {//四维地图
                if (childType == -1) {
                    ft.replace(R.id.frame_layout, foreMapFragment)
                } else if (childType == 1) {//高精
                    ft.replace(R.id.frame_layout, unityFragment)
                } else if (childType == 2) {//局部
                    ft.replace(R.id.frame_layout, partRoadFragment)
                }
            } else if (mapType == MAP_TYPE.AMAP.ordinal) {
                if (childType == -1) {
                    ft.replace(R.id.frame_layout, aMapFragment)
                } else if (childType == 1) {//高精

                } else if (childType == 2) {//局部

                } else {
                    ft.replace(R.id.frame_layout, aMapFragment)
                }
            }
            ft.commit()
        }
    }


    /**地图加载监听回调*/
    fun addMapRenderCallback(onMapReadyLis: OnMapReadyLis) {
        if (mapType == 0) {//四维地图
            if (childType == -1) {
                foreMapFragment.addMapRenderCallback(onMapReadyLis)
            } else if (childType == 1) {//高精
                unityFragment.addMapRenderCallback(onMapReadyLis)
            } else if (childType == 2) {//局部
                partRoadFragment.addMapRenderCallback(onMapReadyLis)
            }

        } else if (mapType == 1) {//高德地图
            aMapFragment.addMapRenderCallback(onMapReadyLis)
        }
    }

//    /**获取 mMineMap 或者 aMap ***/
//    fun getAnyMap(): Any? {
//        if (mapType == 0) {
//            return foreMapFragment.getAnyMap() as MineMap
//        } else if (mapType == 1) {
//            return aMapFragment.getAnyMap() as AMap
//        }
//        return null
//    }

    /**设置局部地图查询地址**/
    fun setRoadBaseUrl(url: String) {
        if (mapType == 0) {//四维地图
            if (childType == 2) {
                partRoadFragment.setRoadBaseUrl(url)
            }
        }
    }

    /**设置指南针的显示隐藏***/
    fun setCompassView(show: Boolean) {
        if (mapType == 0) {//四维地图
            foreMapFragment.setCompassView(show)
        } else if (mapType == 1) {//高德地图
            aMapFragment.setCompassView(show)
        }
    }

    /**设置比例尺的显示隐藏***/
    fun setScaleControlsEnabled(bool: Boolean) {
        if (mapType == 0) {//四维地图
            foreMapFragment.setScaleControlsEnabled(bool)
        } else if (mapType == 1) {//高德地图
            aMapFragment.setScaleControlsEnabled(bool)
        }
    }

    /****设置定位按钮***/
    fun setMyLocationButtonEnabled(bool: Boolean) {
        if (mapType == 0) {//四维地图
            foreMapFragment.setMyLocationButtonEnabled(bool)
        } else if (mapType == 1) {//高德地图
            aMapFragment.setMyLocationButtonEnabled(bool)
        }
    }


}

