package com.cusc.map.scenario.mine

import com.minedata.minenavi.mapdal.LatLng
import com.cusc.map.highmap.HighMap
import com.cusc.map.highmap.HighPos
import com.cusc.map.maps.MSNavi
import com.cusc.map.maps.MethodAdv
import com.cusc.map.parkroad.MsParkRoad
import com.cusc.map.parkroad.RoadPos
import com.cusc.map.scenario.CucsVehicle
import com.cusc.map.scenario.VehicleModel
import com.cusc.map.scenario.bean.VehiclePos
import com.cusc.map.utils.SmoothMoveUtils

//四维实现移动
internal object MineVehMove {

    //动画是否开始
    private var isAniStart = false

    //前一次位置
    private var fromLoc: VehiclePos? = null

    //当前位置
    private var cvPos: VehiclePos? = null

    //保存上一次位置的时间
    private var oldTime = 0L

    //2次定位的时间差，默认1000毫秒
    private var vehTimeDiff = 1000L

    //移动地图中心点的此时
    private var mapCenCount = 0

    fun mineCarMove(vPos: VehiclePos, moveType: Int) {
        cvPos = vPos
        if (moveType == 1) {
            var highPos = HighPos.instance.apply {
                heading = vPos.heading
                lat = vPos.lat
                lon = vPos.lng
                evel = vPos.evel
            }
            HighMap.setCarPosition(highPos)
        } else if (moveType == 2) {
            var roadPos = RoadPos.instance.apply {
                lat = vPos.lat
                lng = vPos.lng
                bearing = vPos.heading.toFloat()
            }
            MsParkRoad.updateMainCar(roadPos, null)
        } else if (moveType == 3) {
            if (MSNavi.isStartNai) {//导航中就删除在线地图小车
                CucsVehicle.deleteCarModel()
            } else {
                if (fromLoc == null || fromLoc?.lng == 0.0) {
                    setFromMyLoc(vPos)//设置起始位置
                }
                //计算2次定位时间差
                calTimeDiff()
                if (isAniStart == false) {
                    isAniStart = true
                    SmoothMoveUtils.startSmoothMove(
                        LatLng(fromLoc!!.lat, fromLoc!!.lng),
                        LatLng(vPos.lat, vPos.lng),
                        vehTimeDiff,
                        sCarSmooth
                    )
                    mapCenCount++
                    if (mapCenCount % 10 == 0) {
                        MethodAdv.setMapCenter(cvPos?.lat ?: 0.0, cvPos?.lng ?: 0.0)
                        mapCenCount = 0
                    }
                }
            }
        }
    }


    //在线地图主车平滑移动
    private var sCarSmooth = object : SmoothMoveUtils.OnPositionUpdateListener {
        override fun onUpdate(
            iLatLng: LatLng,
            bearing: Float
        ) {
            //在线地图主车平滑移动
            VehicleModel.upMyLocCarModel(
                iLatLng.latitude,
                iLatLng.longitude,
                cvPos?.heading?.toFloat() ?: 0f
            )
        }

        override fun onFinish() {
//            println("--------------动画完成")
            setFromMyLoc(cvPos!!)
            isAniStart = false
        }
    }

    //计算2次拿到车辆定位的时间差
    fun calTimeDiff() {
//        CoroutineScope(Dispatchers.Default).launch {
            if (oldTime != 0L) {
                vehTimeDiff = System.currentTimeMillis() - oldTime
//                println("-------定位时间差 = ${vehTimeDiff}")
            }
            oldTime = System.currentTimeMillis()
//        }
    }

    //设置前一个点
    private fun setFromMyLoc(myloc: VehiclePos) {
        if (fromLoc == null) {
            fromLoc = VehiclePos()
        }
        fromLoc!!.run {
            this.lat = myloc.lat
            this.lng = myloc.lng
            this.heading = myloc.heading
            this.evel = myloc.evel
        }
    }
}