package com.cusc.map.scenario.mine

import com.amap.api.maps.CameraUpdateFactory
import com.amap.api.maps.model.BitmapDescriptorFactory
import com.amap.api.maps.model.LatLng
import com.amap.api.maps.model.Marker
import com.amap.api.maps.model.MarkerOptions
import com.amap.api.maps.utils.overlay.MovingPointOverlay
import com.cusc.map.R
import com.cusc.map.maps.MSNavi
import com.cusc.map.maps.MsOperationParent
import com.cusc.map.scenario.CucsVehicle
import com.cusc.map.scenario.bean.VehiclePos
import kotlinx.coroutines.CoroutineScope
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.delay
import kotlinx.coroutines.launch


//高德实现移动
internal object AmapVehMove : MsOperationParent() {

    private var smoothMarker: MovingPointOverlay? = null
    private var marker: Marker? = null

    //轨迹点
    private var subList = mutableListOf<LatLng>()

    //保存上一次位置的时间
//    private var oldTime = 0L
//
//    //2次定位的时间差，默认1000毫秒
//    private var vehTimeDiff = 1000L

    fun aMapCarMove(vPos: VehiclePos, moveType: Int) {
        if (moveType == 3) {
            if (MSNavi.isStartNai) {//导航中就删除在线地图小车
                CucsVehicle.deleteCarModel()
            } else {
                //计算2次定位时间差
//                calTimeDiff()
                var mAMap = getMapReadView()?.aMap
                // 实例 MovingPointOverlay 对象
                if (smoothMarker == null) {
                    // 设置 平滑移动的 图标
                    marker = mAMap?.addMarker(
                        MarkerOptions().icon(BitmapDescriptorFactory.fromResource(R.drawable.icon_car))
                            .anchor(0.5f, 0.5f)
                    )
                    smoothMarker = MovingPointOverlay(mAMap, marker)
                }

                subList.add(LatLng(vPos.lat, vPos.lng))
                if (subList.count() > 3) {
                    // 构建 轨迹的显示区域
//                val builder = LatLngBounds.Builder()
//                builder.include(subList.first())
//                builder.include(subList.get(subList.count() - 2))
//                mAMap?.animateCamera(CameraUpdateFactory.newLatLngBounds(builder.build(), 30))
                    mAMap?.moveCamera(CameraUpdateFactory.newLatLng(LatLng(vPos.lat, vPos.lng)))
                    // 设置轨迹点
                    smoothMarker?.setPoints(subList)
                    // 设置平滑移动的总时间  单位  秒
                    smoothMarker?.setTotalDuration(1)
                    //开始移动
                    smoothMarker?.startSmoothMove()
                    CoroutineScope(Dispatchers.Default).launch {
                        delay(1000)
                        subList.clear()
                    }
                }
//                smoothMarker?.setMoveListener { distance->
//                    if (distance.toInt() in 0..5) {
//                        smoothMarker?.stopMove()
//                        subList.clear()
//                    }
//                }
            }

        }
    }

    fun stopMove() {
        smoothMarker?.stopMove()
    }


    fun deleteCarModel() {
        smoothMarker?.removeMarker()
        smoothMarker = null
        marker?.remove()
        marker = null
    }

}

