package com.cusc.map.scenario

import com.cusc.map.MAP_TYPE
import com.cusc.map.MSDKInitializer
import com.cusc.map.highmap.CarNavPath
import com.cusc.map.highmap.HighMap
import com.cusc.map.scenario.bean.VehiclePos
import com.cusc.map.scenario.mine.AmapVehMove
import com.cusc.map.scenario.mine.MineVehMove
import com.cusc.map.scenario.mine.MineVehicleModel

/**车辆管理类***/
object CucsVehicle {

    //控制车辆是否暂停移动
    private var stopCar = false

    /**
     * 移动车辆
     * @param vPos 车辆位置
     * @param moveType 1=高精地图 2= 局部地图 3=在线地图
     */
    fun moveCar(vPos: VehiclePos, moveType: Int) {
        if (stopCar)
            return
        when (MSDKInitializer.getMapType()) {
            MAP_TYPE.MINE -> {
                MineVehMove.mineCarMove(vPos, moveType)
            }

            MAP_TYPE.AMAP -> {
                AmapVehMove.aMapCarMove(vPos, moveType)
            }
        }
    }

    /**停止车辆移动*/
    fun stopCar() {
        stopCar = true
        when (MSDKInitializer.getMapType()) {
            MAP_TYPE.MINE -> {
            }

            MAP_TYPE.AMAP -> {
                AmapVehMove.stopMove()
            }
        }
    }

    /**恢复车辆移动*/
    fun resumeCarMove() {
        stopCar = false
        when (MSDKInitializer.getMapType()) {
            MAP_TYPE.MINE -> {
                MineVehicleModel.loadAddCar = false
            }

            MAP_TYPE.AMAP -> {
            }
        }
    }

    /**删除在线地图车辆***/
    fun deleteCarModel() {
        stopCar = true
        when (MSDKInitializer.getMapType()) {
            MAP_TYPE.MINE -> {
                VehicleModel.deleteMyLocModel()
//                stopCar = false
            }

            MAP_TYPE.AMAP -> {
                AmapVehMove.deleteCarModel()
            }
        }
    }


    /**
     * 设置车辆移动路径
     * @param carNavPath
     */
    fun setCarNaiPath(carNavPath: CarNavPath) {
        HighMap.setCarNavPath(carNavPath)
    }

    /**
     * 清除车辆移动路径
     */
    fun clearCarNaiPath() {
        var carNavPath = CarNavPath()
        HighMap.setCarNavPath(carNavPath)
    }


}