package com.cusc.map.parkroad

import android.content.res.AssetManager
import com.example.car_and_road_3d.models.Alarm
import com.example.car_and_road_3d.models.EarlyMarker
import com.example.car_and_road_3d.models.Participant
import com.example.car_and_road_3d.models.Position
import com.cusc.map.MAP_TYPE
import com.cusc.map.MSDKInitializer
import com.cusc.map.maps.MsOperationParent
import com.cusc.map.ui.MapReadyView
import com.cusc.map.vms.CarRoadVM

/**
 * 局部图操作类
 */
object MsParkRoad : MsOperationParent() {

    private var carRoadVM: CarRoadVM? = null

    /**
     *设置局部地图控制器
     * @param mapReadyView 地图容器
     */
    fun setCarRoadVM(mapReadyView: MapReadyView?) {
        if (mapReadyView == null)
            return
        when (MSDKInitializer.getMapType()) {
            MAP_TYPE.MINE -> {
                carRoadVM = mapReadyView.carRoadVM
            }

            MAP_TYPE.AMAP -> {
            }
        }
    }

    /**
     *初始化局部视图控制器
     */
    /* fun initCarRoadVM() {
         when (MSDKInitializer.getMapType()) {
             MAP_TYPE.MINE -> {
                 carRoadVM = getMapReadView()?.carRoadVM
             }

             MAP_TYPE.AMAP -> {
             }
         }
     }*/

    /**
     *更新主车我只
     * @param roadPos 当前位置
     * @param onPrAddCar 回调
     */
    fun updateMainCar(roadPos: RoadPos, onPrAddCar: OnPrAddCar?) {
        when (MSDKInitializer.getMapType()) {
            MAP_TYPE.MINE -> {
                carRoadVM?.updateMainCar(roadPos, onPrAddCar)
            }

            MAP_TYPE.AMAP -> {
            }
        }
    }


    /**添加底部光圈
     *@param circle true:显示底部光圈 false:不显示底部光圈
     */
    fun showWarningCircle(circle: Boolean) {
        when (MSDKInitializer.getMapType()) {
            MAP_TYPE.MINE -> {
                carRoadVM?.webViewClient?.showWarningCircle(circle) {}
            }

            MAP_TYPE.AMAP -> {
            }
        }
    }

    /**设置感知物显示距离(米)
     * @param distance
     */
    fun setDistanceVisible(distance: Double) {
        when (MSDKInitializer.getMapType()) {
            MAP_TYPE.MINE -> {
                carRoadVM?.webViewClient?.setDistanceVisible(distance) {}
            }

            MAP_TYPE.AMAP -> {
            }
        }
    }

    /**跟车视角
     * @param camera 0、25、45、75、90度
     */
    fun setCameraPosition(camera: Double) {
        when (MSDKInitializer.getMapType()) {
            MAP_TYPE.MINE -> {
                carRoadVM?.webViewClient?.setCameraPosition(camera) {}
            }

            MAP_TYPE.AMAP -> {
            }
        }
    }

    /**显示人行道*/
    fun showWalkLine(showWalk: Boolean) {
        when (MSDKInitializer.getMapType()) {
            MAP_TYPE.MINE -> {
                carRoadVM?.webViewClient?.showWalkLine(showWalk) { }
            }

            MAP_TYPE.AMAP -> {
            }
        }
    }

    /**局部图显示marker
     * @param marker 1:结冰 2:施工 3:交叉路口慢行
     * */
    fun showMarker(marker: Int) {
        when (MSDKInitializer.getMapType()) {
            MAP_TYPE.MINE -> {
                if (marker == -1) {
                    carRoadVM?.webViewClient?.showEarlyMarker(EarlyMarker.NONE) {}
                } else if (marker == 1) {
                    carRoadVM?.webViewClient?.showEarlyMarker(EarlyMarker.JIE_BING) {}
                } else if (marker == 2) {
                    carRoadVM?.webViewClient?.showEarlyMarker(EarlyMarker.SHI_GONG) {}
                } else if (marker == 3) {
                    carRoadVM?.webViewClient?.showEarlyMarker(EarlyMarker.MAN_XING) {}
                } else {
                    carRoadVM?.webViewClient?.showEarlyMarker(EarlyMarker.DEFAULT) {}
                }
            }

            MAP_TYPE.AMAP -> {
            }
        }

    }

    /**开启雷达*/
    fun toggleRadar(radar: Boolean) {
        when (MSDKInitializer.getMapType()) {
            MAP_TYPE.MINE -> {
                carRoadVM?.webViewClient?.showRadar(radar) {}
            }

            MAP_TYPE.AMAP -> {
            }
        }
    }

    /**
     * 预警特效（单个）
     * @param ptcId 感知物id
     * @param isRed 是否变红
     * @param time 动画持续时间
     */
    fun warnAlerm(ptcId: String, isRed: Boolean, time: Int) {
        when (MSDKInitializer.getMapType()) {
            MAP_TYPE.MINE -> {
                var alarm = Alarm(ptcId, isRed, time)
                carRoadVM?.webViewClient?.setAlarms(listOf(alarm), null)
            }

            MAP_TYPE.AMAP -> {
            }
        }
    }
    /**
     * 预警特效批量
     */
    fun warnAlerms(alarms: List<Alarm>) {
        when (MSDKInitializer.getMapType()) {
            MAP_TYPE.MINE -> {
                carRoadVM?.webViewClient?.setAlarms(alarms, null)
            }

            MAP_TYPE.AMAP -> {
            }
        }
    }

    /**更新参与者***/
    fun upDatePreTarget(prelist: List<PtcBean>) {
        when (MSDKInitializer.getMapType()) {
            MAP_TYPE.MINE -> {
                if (prelist.count() == 0) {
                    carRoadVM?.webViewClient?.clearAllTargets(null)
                    return
                }
                var ptcs = prelist.mapIndexed { index, pre ->
                    //道路参与者
                    var participant: Participant

                    var ptcType = Participant.ParticipantType.CAR
                    if (pre.ptcType == 1) {
                        ptcType = Participant.ParticipantType.CAR
                    } else if (pre.ptcType == 2) {
                        ptcType = Participant.ParticipantType.PEOPLE
                    }
                    participant =
                        Participant(pre.ptcId, ptcType, Position(pre.lat, pre.lng), pre.heading)
                    participant
                }
                carRoadVM?.webViewClient?.refreshParticipants(ptcs, null)
            }

            MAP_TYPE.AMAP -> {
            }
        }
    }

    /**清除所有参与者***/
    fun clearAllTargets() {
        when (MSDKInitializer.getMapType()) {
            MAP_TYPE.MINE -> {
                carRoadVM?.webViewClient?.clearAllTargets(null)
            }

            MAP_TYPE.AMAP -> {
            }
        }
    }

    /**预加载主车
     * @param fileName 模型文件路径 glb格式
     */
    fun preloadMainCar(assets: AssetManager, fileName: String) {
        when (MSDKInitializer.getMapType()) {
            MAP_TYPE.MINE -> {
                carRoadVM?.webViewClient?.preloadMainCar(assets.open(fileName)) { v: Boolean ->
//                    println("-------preloadMainCar = ${v}")
                }
            }

            MAP_TYPE.AMAP -> {
            }
        }
    }

    /**
     * 预加载感知物
     * @param fileName 模型文件路径 glb格式
     */
    fun preloadParticipant(assets: AssetManager, fileName: String, ptcType: PartType) {
        when (MSDKInitializer.getMapType()) {
            MAP_TYPE.MINE -> {
                if (ptcType == PartType.CAR) {
                    carRoadVM?.webViewClient?.preloadParticipant(
                        Participant.ParticipantType.CAR,
                        assets.open(fileName)
                    ) { v: Boolean ->
//                println("-------------preloadParticipant = ${v}")
                    }
                } else if (ptcType == PartType.PEOPLE) {
                    carRoadVM?.webViewClient?.preloadParticipant(
                        Participant.ParticipantType.PEOPLE,
                        assets.open(fileName)
                    ) { }
                }
            }

            MAP_TYPE.AMAP -> {
            }
        }
    }


}