package com.cusc.map.maps.mine

import com.minedata.minenavi.map.MyLocationStyle
import com.cusc.map.ui.MapReadyView
import com.cusc.map.maps.MSLocStyle

/**
 * 四维显示定位小圆点
 */
internal object MineLocationStyle {

    // 四维初始化定位蓝点样式类
    private val myLocationStyle by lazy { MyLocationStyle() }

    /**
     * 设置定位蓝点样式
     * @param mapReadView 地图准备就绪视图对象
     * @param type 定位类型，默认为LOCATION_TYPE_LOCATION_ROTATE，表示连续定位并旋转视角
     */
    fun setLocationStyle(
        mapReadView: MapReadyView?,
        type: Int = MSLocStyle.LOCATION_TYPE_LOCATION_ROTATE
    ) {
        var mMineMap = mapReadView?.mMineMap

// 连续定位、且将视角移动到地图中心点，定位点依照设备方向旋转，并且会跟随设备移动。（1秒1次定位）如果不设置myLocationType，默认也会执行此种模式。
        myLocationStyle.myLocationType(type)
// 设置连续定位模式下的定位间隔，只在连续定位模式下生效，单次定位模式下不会生效。单位为毫秒。
        myLocationStyle.interval(2000)
// 设置为true表示显示定位蓝点，false表示隐藏定位蓝点并不进行定位，默认是true。
        myLocationStyle.showMyLocation(true)

        mMineMap?.setMyLocationStyle(myLocationStyle)

    }


}