package com.cusc.map.maps.amap

import android.graphics.BitmapFactory
import androidx.core.graphics.toColorInt
import com.amap.api.maps.model.BitmapDescriptorFactory
import com.amap.api.maps.model.CircleOptions
import com.amap.api.maps.model.LatLng
import com.amap.api.maps.model.MarkerOptions
import com.amap.api.maps.model.PolygonOptions
import com.amap.api.maps.model.PolylineOptions
import com.cusc.map.R
import com.cusc.map.UserCtx
import com.cusc.map.maps.MsCircleOptions
import com.cusc.map.maps.MsPolygonOptions
import com.cusc.map.maps.MsPolylineOptions
import com.cusc.map.maps.cdata.MSLatLng
import com.cusc.map.ui.MapReadyView
import com.cusc.map.maps.cdata.MSOverlay
import com.cusc.map.maps.cdata.MSMarker

/**
 * 在地图上绘制
 */
object AmapDrawInMap {


    /**
     * 绘制 marker 点
     * @param mapReadView 地图准备就绪的视图对象
     * @param lat 纬度坐标
     * @param lng 经度坐标
     * @return MSMarker 标记点对象
     */
    fun drawMarket(
        mapReadView: MapReadyView?,
        lat: Double,
        lng: Double
    ): MSMarker {
        var context = UserCtx.Companion.instance.mContext

        // 处理高德地图类型的标记点绘制
        val aLatLng = LatLng(lat, lng)
        val aMarkerOption = MarkerOptions().apply {
            position(aLatLng)
            icon(
                BitmapDescriptorFactory.fromBitmap(
                    BitmapFactory
                        .decodeResource(context?.resources, R.drawable.market_loc)
                )
            )
        }
        var aMaker = mapReadView?.aMap?.addMarker(aMarkerOption)
        MSMarker.amaker = aMaker
        return MSMarker
    }


    /**
     * 绘制线
     * @param mapReadView 地图加载返回
     * @param msLatLng 坐标点集合
     * @param msPolylineOptions 绘制线选项
     * @return MSOverlay 覆盖物对象
     */
    fun drawPolyline(
        mapReadView: MapReadyView?,
        msLatLng: List<MSLatLng>,
        msPolylineOptions: MsPolylineOptions
    ): MSOverlay {
        // 绘制高德地图的线
        var latLngs = msLatLng.map {
            LatLng(it.lat, it.lng)
        }
        val aOption = PolylineOptions().addAll(latLngs)
            .width(msPolylineOptions.width)
            .color(msPolylineOptions.fcolor)
            .setDottedLine(msPolylineOptions.isDotted)
        var polyline = mapReadView?.aMap?.addPolyline(aOption)
        MSOverlay.aPolyline = polyline
        return MSOverlay
    }


    /**绘制圆形
     * @param mapReadView 地图准备就绪视图对象
     * @param center 中心点坐标
     * @param msCircleOptions 绘制圆形选项
     * @return MSOverlay 返回覆盖物对象
     */
    fun drawCircle(
        mapReadView: MapReadyView?,
        center: MSLatLng,
        msCircleOptions:MsCircleOptions?
    ): MSOverlay {
        var latLng = LatLng(center.lat, center.lng)
        val options = CircleOptions()
            .center(latLng)
            .radius(msCircleOptions?.radius?.toDouble()?:100.0)
            .fillColor(msCircleOptions?.fillColor?:"#50FF0000".toColorInt())
            .strokeColor(msCircleOptions?.strokeColor?:"#500000FF".toColorInt())
            .strokeWidth(msCircleOptions?.strokeWidth?:15f)
        var circle = mapReadView?.aMap?.addCircle(options)
        MSOverlay.aCircle = circle
        return MSOverlay
    }


    /**
     * 绘制多边形
     * @param msLatLng   添加多边形顶点坐标集合
     * @param  msPolygonOptions 多边形绘制选型
     */
    fun drawPolygon(
        mapReadView: MapReadyView?,
        msLatLng: List<MSLatLng>,
        msPolygonOptions:MsPolygonOptions
    ): MSOverlay {
        var latLngs = msLatLng.map {
            LatLng(it.lat, it.lng)
        }
        val aPolygonOptions = PolygonOptions().apply {
            addAll(latLngs)
            fillColor(msPolygonOptions.fillColor)
            strokeWidth(msPolygonOptions.strokeWidth)
            strokeColor(msPolygonOptions.strokeColor)
        }
        var polygon = mapReadView?.aMap?.addPolygon(aPolygonOptions)
        MSOverlay.aPolygon = polygon
        return MSOverlay
    }

}