package com.cusc.map.maps

import com.cusc.map.MAP_TYPE
import com.cusc.map.MSDKInitializer
import com.cusc.map.bean.WayPoi
import com.cusc.map.maps.amap.AmapRoutePlans
import com.cusc.map.maps.cdata.MSLatLng
import com.cusc.map.maps.inters.OnDriveRoute
import com.cusc.map.maps.mine.MineRoutePlans


/**路劲规划 **/
object MSRoutePlans : MsOperationParent() {

    /**驾车路径规划
     * @param starPoint 起点坐标
     * @param startName 起点名称
     * @param endPoint 终点坐标
     * @param endName 终点名称（高德可不传）
     * @param ways     途经点集合
     * @param mapReadView 地图对象
     * @param onDriveRoute 路径规划结果回调
     */
    fun drivingPathPlanning(
        starPoint: MSLatLng,
        startName: String = "当前位置",
        endPoint: MSLatLng,
        endName: String = "",
        ways: List<WayPoi>,
        onDriveRoute: OnDriveRoute?
    ) {
        var mapReadView = getMapReadView()
        when (MSDKInitializer.getMapType()) {
            MAP_TYPE.MINE -> {
                MineRoutePlans.drivingPathPlanning(
                    starPoint,
                    startName,
                    endPoint,
                    endName,
                    ways,
                    mapReadView,
                    onDriveRoute
                )
            }

            MAP_TYPE.AMAP -> {
                AmapRoutePlans.instance.drivingPathPlanning(
                    starPoint,
                    startName,
                    endPoint,
                    endName,
                    ways,
                    mapReadView,
                    onDriveRoute
                )
            }
        }
    }

}