package com.cusc.map.maps

import com.cusc.map.MAP_TYPE
import com.cusc.map.MSDKInitializer
import com.cusc.map.maps.amap.AmapPoiSearch
import com.cusc.map.maps.inters.OnMSPoiSearchLis
import com.cusc.map.maps.mine.MinePoiSearch

/**
 * poi 搜索
 */
object MSPoi {

    /**关键字搜索
     * @param keyWord 关键字
     * @param lat 当期维度
     * @param lng 当期经度
     * @param adCode 行政区编码
     * @param onMSPoiSearchLis 搜索回调
     */
    fun startPoiSearch(
        keyWord: String,
        lat: Double,
        lng: Double,
        adCode: String,
        onMSPoiSearchLis: OnMSPoiSearchLis
    ){
        when (MSDKInitializer.getMapType()) {
            MAP_TYPE.MINE -> {
                MinePoiSearch.startPoiSearch(keyWord, lat, lng,adCode, onMSPoiSearchLis)
            }

            MAP_TYPE.AMAP -> {
                AmapPoiSearch.startPoiSearch(keyWord, lat, lng, onMSPoiSearchLis)
            }
        }
    }


    /**周边搜索
     * @param keyWord 关键字
     * @param lat 当前维度
     * @param lng 当前经度
     * @param radios 搜索半径(单位 米)
     * @param onMSPoiSearchLis 回调
     */
    fun startPoiSearchBound(
        keyWord: String,
        lat: Double,
        lng: Double,
        radios: Int,
        onMSPoiSearchLis: OnMSPoiSearchLis
    ){
        when (MSDKInitializer.getMapType()) {
            MAP_TYPE.MINE -> {
                MinePoiSearch.startPoiSearchBound(keyWord, lat, lng, radios,onMSPoiSearchLis)
            }

            MAP_TYPE.AMAP -> {
                AmapPoiSearch.startPoiSearchBound(keyWord, lat, lng, radios, onMSPoiSearchLis)
            }
        }
    }

}