package com.cusc.map.maps

import com.cusc.map.MAP_TYPE
import com.cusc.map.MSDKInitializer
import com.cusc.map.ui.MapReadyView
import com.cusc.map.maps.amap.AmapLocationStyle
import com.cusc.map.maps.mine.MineLocationStyle

/**
 * 显示定位蓝点
 *
 * @constructor Create empty Show my loc style
 */
object LocStyle {

    /**
     * 设置定位蓝点样式
     * @param mapReadView 地图准备就绪视图对象
     * @param type 定位类型，默认为LOCATION_TYPE_LOCATION_ROTATE，表示连续定位并旋转视角
     */
    fun setLocationStyle(
        mapReadView: MapReadyView?,
        type: Int = MSLocStyle.LOCATION_TYPE_LOCATION_ROTATE
    ){
        when (MSDKInitializer.getMapType()) {
            MAP_TYPE.MINE -> {
                MineLocationStyle.setLocationStyle(mapReadView, type)
            }

            MAP_TYPE.AMAP -> {
                AmapLocationStyle.setLocationStyle(mapReadView, type)
            }
        }
    }
}