package com.cusc.map.maps

import com.cusc.map.MAP_TYPE
import com.cusc.map.MSDKInitializer
import com.cusc.map.maps.amap.AmapGestures
import com.cusc.map.maps.mine.MineGestures

/**
 * 手势控制
 */
object Gestures : MsOperationParent() {

    /**
     * 设置地图旋转手势是否可用
     * @param mapReadView 地图准备就绪视图对象
     * @param enable 是否启用旋转手势功能
     */
    fun setRotateGesturesEnabled(enable: Boolean){
        var mapReadView = getMapReadView()
        when (MSDKInitializer.getMapType()) {
            MAP_TYPE.MINE -> {
                MineGestures.setRotateGesturesEnabled(mapReadView, enable)
            }

            MAP_TYPE.AMAP -> {
                AmapGestures.setRotateGesturesEnabled(mapReadView, enable)
            }
        }
    }


    /**
     * 设置地图倾斜手势功能的启用状态
     * @param mapReadView 地图准备就绪视图对象
     * @param enable 是否启用倾斜手势功能，true为启用，false为禁用
     * */
    fun setTiltGesturesEnabled(enable: Boolean){
        var mapReadView = getMapReadView()
        when (MSDKInitializer.getMapType()) {
            MAP_TYPE.MINE -> {
                MineGestures.setTiltGesturesEnabled(mapReadView, enable)
            }

            MAP_TYPE.AMAP -> {
                AmapGestures.setTiltGesturesEnabled(mapReadView, enable)
            }
        }
    }
}