package com.cusc.map.maps

import androidx.core.graphics.toColorInt
import com.cusc.map.MAP_TYPE
import com.cusc.map.MSDKInitializer
import com.cusc.map.maps.amap.AmapDrawInMap
import com.cusc.map.maps.cdata.MSLatLng
import com.cusc.map.maps.cdata.MSMarker
import com.cusc.map.maps.cdata.MSOverlay
import com.cusc.map.maps.mine.MineDrawInMap

/***绘制线选项**/
class MsPolylineOptions {
    /***填充颜色**/
    var fcolor = "#000000".toColorInt()

    /***描边颜色**/
    var outlineColor = "#00000000".toColorInt()

    /***线宽度，默认为10f**/
    var width = 10f

    /***是否为虚线，默认为false**/
    var isDotted = false
}


/***绘制圆形选项**/
class MsCircleOptions {
    /**半径（米）**/
    var radius = 100f

    /***填充颜色，默认为半透明红色*/
    var fillColor = "#50FF0000".toColorInt()

    /***边框颜色，默认为半透明蓝色*/
    var strokeColor = "#500000FF".toColorInt()

    /*** 边框宽度，默认为15f*/
    var strokeWidth = 15f
}

/***绘制一个面选项**/
class MsPolygonOptions {
    /***填充颜色**/
    var fillColor = "#10FF00FF".toColorInt()

    /***边框颜色**/
    var strokeColor = "#500000FF".toColorInt()

    /***边框宽度**/
    var strokeWidth = 5f

    /***是否为虚线，默认为false**/
    var dLine = false
}


/**
 * 绘制点、线、面
 */
object DrawInMap : MsOperationParent() {

    /**
     * 绘制 marker 点
     * @param lat 纬度坐标
     * @param lng 经度坐标
     * @return MSMarker 标记点对象
     */
    fun drawMarket(
        lat: Double,
        lng: Double
    ): MSMarker {
        val mapReadView = getMapReadView()
        when (MSDKInitializer.getMapType()) {
            MAP_TYPE.MINE -> {
                return MineDrawInMap.drawMarket(mapReadView, lat, lng)
            }

            MAP_TYPE.AMAP -> {
                return AmapDrawInMap.drawMarket(mapReadView, lat, lng)
            }
        }
    }

    /**
     * 绘制线
     * @param msLatLng 坐标点集合
     * @param msPolylineOptions 绘制线选项
     * @return MSOverlay 覆盖物对象
     */
    fun drawPolyline(
        msLatLng: List<MSLatLng>, msPolylineOptions: MsPolylineOptions
    ): MSOverlay {
        val mapReadView = getMapReadView()
        when (MSDKInitializer.getMapType()) {
            MAP_TYPE.MINE -> {
                return MineDrawInMap.drawPolyline(
                    mapReadView,
                    msLatLng,
                    msPolylineOptions
                )
            }

            MAP_TYPE.AMAP -> {
                return AmapDrawInMap.drawPolyline(mapReadView, msLatLng, msPolylineOptions)
            }
        }
    }

    /**
     * 绘制圆形
     * @param center 中心点坐标
     * @param msCircleOptions 绘制圆形选项
     * @return MSOverlay 返回覆盖物对象
     */
    fun drawCircle(
        center: MSLatLng,
        msCircleOptions: MsCircleOptions?
    ): MSOverlay {
        val mapReadView = getMapReadView()
        when (MSDKInitializer.getMapType()) {
            MAP_TYPE.MINE -> {
                return MineDrawInMap.drawCircle(
                    mapReadView, center,
                    msCircleOptions
                )
            }

            MAP_TYPE.AMAP -> {
                return AmapDrawInMap.drawCircle(
                    mapReadView,
                    center,
                    msCircleOptions
                )
            }
        }
    }

    /**
     * 绘制多边形
     * @param msLatLng   添加多边形顶点坐标集合
     * @param msPolygonOptions 多边形绘制选型
     */
    fun drawPolygon(
        msLatLng: List<MSLatLng>,
        msPolygonOptions: MsPolygonOptions
    ): MSOverlay {
        val mapReadView = getMapReadView()
        when (MSDKInitializer.getMapType()) {
            MAP_TYPE.MINE -> {
                return MineDrawInMap.drawPolygon(
                    mapReadView,
                    msLatLng,
                    msPolygonOptions
                )
            }

            MAP_TYPE.AMAP -> {
                return AmapDrawInMap.drawPolygon(
                    mapReadView, msLatLng,
                    msPolygonOptions
                )
            }
        }
    }

}