package com.cusc.map.location

import com.cusc.map.MAP_TYPE
import com.cusc.map.MSDKInitializer
import com.cusc.map.maps.amap.AmapGpsLocation

/**
 * 定位类
 */
object MSLocation {

    fun initLoc(){
        when (MSDKInitializer.getMapType()) {
            MAP_TYPE.MINE -> {
                MineGpsLocation.initLoc()
            }

            MAP_TYPE.AMAP -> {

            }
        }
    }

    /**
     * 开启定位
     * 设置GPS定位回调监听器
     * @param onMsGpsLoc GPS定位回调监听器实例
     */
    fun startLoc(onMsGpsLoc: OnMsGpsLoc?){
        when (MSDKInitializer.getMapType()) {
            MAP_TYPE.MINE -> {
                MineGpsLocation.starLoc(onMsGpsLoc)
            }

            MAP_TYPE.AMAP -> {
                AmapGpsLocation.instance.starLoc(onMsGpsLoc)
            }
        }
    }

    /**停止定位*/
    fun stopLoc(){
        when (MSDKInitializer.getMapType()) {
            MAP_TYPE.MINE -> {
                MineGpsLocation.stopLoc()
            }

            MAP_TYPE.AMAP -> {
                AmapGpsLocation.instance.stopLoc()
            }
        }
    }

    /**清理定位资源**/
    fun cleansLoc(){
        when (MSDKInitializer.getMapType()) {
            MAP_TYPE.MINE -> {
                MineGpsLocation.cleansLoc()
            }

            MAP_TYPE.AMAP -> {
                AmapGpsLocation.instance.cleansLoc()
            }
        }
    }
}