package com.cusc.map.highmap

import com.google.gson.Gson
import com.cusc.map.MAP_TYPE
import com.cusc.map.MSDKInitializer
import com.cusc.map.maps.MsOperationParent
import com.unity3d.player.UnityPlayer


/**
 * 四维高精地图操作
 */
object HighMap :MsOperationParent() {

    private var gson = Gson()

    private const val MODELNAME = "MsgBridge"

    /**
     * 加载3D Tiles
     * @param tileType 1=亦庄示范区
     */
    fun setTileInit(tileType: Int) {
        when (MSDKInitializer.getMapType()) {
            MAP_TYPE.MINE -> {
                if (!isLoadUnityPlayer())
                    return
                var tileJsonBean = TileJsonBean(tileType)
                tileJsonBean.getTileJson()
                UnityPlayer.UnitySendMessage(MODELNAME, "SetTileInit", gson.toJson(tileJsonBean))
            }

            MAP_TYPE.AMAP -> {
            }
        }
    }

    /**
     * 根据外界传入的坐标，航向角，速度使主车移动
     * @param heading 航向角
     * @param evel 高程
     */
    fun setCarPosition(
        heading: Double,
        lat: Double,
        lon: Double,
        evel: Double,
    ) {
        when (MSDKInitializer.getMapType()) {
            MAP_TYPE.MINE -> {
                if (!isLoadUnityPlayer())
                    return
                val carPos = HighPos().apply {
                    this.heading = heading
                    this.lat = lat
                    this.lon = lon
                    this.evel = evel
                }
                UnityPlayer.UnitySendMessage(MODELNAME, "SetCarPosition", gson.toJson(carPos))
            }

            MAP_TYPE.AMAP -> {
            }
        }
    }

    /**
     * @param highPos 车辆位置对象
     */
    fun setCarPosition(highPos:HighPos) {
        when (MSDKInitializer.getMapType()) {
            MAP_TYPE.MINE -> {
                if (!isLoadUnityPlayer())
                    return
                UnityPlayer.UnitySendMessage(MODELNAME, "SetCarPosition", gson.toJson(highPos))
            }

            MAP_TYPE.AMAP -> {
            }
        }
    }


    /**
     * 开启（关闭）绘制主车底盘下的光圈
     * @param isOn true:显示 false:隐藏
     */
    fun setCarBottomCircle(isOn: Boolean) {
        when (MSDKInitializer.getMapType()) {
            MAP_TYPE.MINE -> {
                var bottomCircle = BottomCircle(isOn)
                UnityPlayer.UnitySendMessage(
                    MODELNAME,
                    "SetCarBottomCircle",
                    gson.toJson(bottomCircle)
                )
            }

            MAP_TYPE.AMAP -> {
            }
        }
    }

    /**
     * 开启（关闭）主车前方的雷达6个方向
     * 0=关闭  1=左前 2=正前 3=右前   4=右后  5=正后  6=左后
     */
    fun setCarRadarDirection(dirent: Int) {
        when (MSDKInitializer.getMapType()) {
            MAP_TYPE.MINE -> {
                var radarDirection = RadarDirection(dirent)
                UnityPlayer.UnitySendMessage(
                    MODELNAME,
                    "SetCarRadarDirection",
                    gson.toJson(radarDirection)
                )
            }

            MAP_TYPE.AMAP -> {
            }
        }
    }

    /**
     * 设置主车导航路径
     * @param lines 路径点列表
     * @param through = "8e959e"     通过路的颜色颜色HEX RRGGBB
     * @param notthrough = "2868D8"    未通过路的颜色颜色HEX RRGGBB
     * @param drawpassed = true    绘制通过路
     * @param showdistance = 45    显示路径的距离，超过这个范围的路径点不绘制
     */
    fun setCarNavPath(
        lines: List<AllLine>,
        notthrough: String = "2868D8",
        through: String = "8e959e",
        drawpassed: Boolean = true,
        showdistance: Int = 45
    ) {
        when (MSDKInitializer.getMapType()) {
            MAP_TYPE.MINE -> {
                var carNavPath = CarNavPath().apply {
                    this.lines = lines
                    this.notthrough = notthrough
                    this.through = through
                    this.drawpassed = drawpassed
                    this.showdistance = showdistance
                }
                UnityPlayer.UnitySendMessage(MODELNAME, "SetCarNavPath", gson.toJson(carNavPath))
            }

            MAP_TYPE.AMAP -> {
            }
        }
    }

    /**
     * 设置主车导航路径
     * @param carNavPath 导航路径选项
     */
    fun setCarNavPath(carNavPath : CarNavPath) {
        when (MSDKInitializer.getMapType()) {
            MAP_TYPE.MINE -> {
                if (!isLoadUnityPlayer())
                    return
                UnityPlayer.UnitySendMessage(MODELNAME, "SetCarNavPath", gson.toJson(carNavPath))
            }

            MAP_TYPE.AMAP -> {
            }
        }
    }

    /**
     * 设置告警线
     * @param alertLins 路径点
     * @param alertType 告警类型 2=红色；3=绿色（绿波）；4=（感知车前的红色）；5= （拥堵红色、施工红色、人行道红色）alertType=-1 时清空所有警戒线。
     */
    fun setAlertPath(alertLine: List<AlertLine>, alertType: Int) {
        when (MSDKInitializer.getMapType()) {
            MAP_TYPE.MINE -> {
                var alertPath = AlertPath(alertLine, alertType)
                UnityPlayer.UnitySendMessage(MODELNAME, "SetAlertPath", gson.toJson(alertPath))
            }

            MAP_TYPE.AMAP -> {
            }
        }
    }

    /**
     * 绘制感知物
     * @param ptcList 感知物列表
     */
    fun setPtcData(ptcList: List<UnityPtc>) {
        when (MSDKInitializer.getMapType()) {
            MAP_TYPE.MINE -> {
                if (!isLoadUnityPlayer())
                    return
                var ptcData = PtcData.instance.apply {
                    this.ptcList = ptcList
                }
                UnityPlayer.UnitySendMessage(MODELNAME, "SetPtcData", gson.toJson(ptcData))
            }

            MAP_TYPE.AMAP -> {
            }
        }
    }

    /**
     * 设置感知物状态
     * @param warnPtc 感知物状态列表
     */
    fun setWarnPtc(warnPtc: List<WarnPtc>) {
        when (MSDKInitializer.getMapType()) {
            MAP_TYPE.MINE -> {
                if (!isLoadUnityPlayer())
                    return
                UnityPlayer.UnitySendMessage(
                    MODELNAME,
                    "SetWarnPre",
                    gson.toJson(warnPtc)
                )
            }

            MAP_TYPE.AMAP -> {
            }
        }
    }

    /**
     * 清空场景中的所有感知物
     */
    fun clearPtcData() {
        when (MSDKInitializer.getMapType()) {
            MAP_TYPE.MINE -> {
                UnityPlayer.UnitySendMessage(MODELNAME, "ClearAllPtcData", "{}")
            }

            MAP_TYPE.AMAP -> {
            }
        }
    }

    /**
     * 调整主摄像机的俯视角度
     */
    fun setCameraAngle(angle: Float = 30f) {
        when (MSDKInitializer.getMapType()) {
            MAP_TYPE.MINE -> {
                UnityPlayer.UnitySendMessage(MODELNAME, "SetCameraAngle", "$angle")
            }

            MAP_TYPE.AMAP -> {
            }
        }
    }


    /**
     * 高亮显示指定车位
     * @param spaceCode 车位编号 当为空时则取消高亮
     */
    fun parkRoundLight(spaceCode: String) {
        when (MSDKInitializer.getMapType()) {
            MAP_TYPE.MINE -> {
                var parkRoundLight = ParkRoundLight().apply {
                    this.spaceCode = spaceCode
                }
                UnityPlayer.UnitySendMessage(
                    MODELNAME,
                    "parkRoundLight",
                    gson.toJson(parkRoundLight)
                )
            }

            MAP_TYPE.AMAP -> {
            }
        }
    }

    /**
     * 设置车辆停车状态,倒车特效
     */
    fun setParkRever(reverCar: ReverCar) {
        when (MSDKInitializer.getMapType()) {
            MAP_TYPE.MINE -> {
                UnityPlayer.UnitySendMessage(MODELNAME, "SetParking", gson.toJson(reverCar))
            }

            MAP_TYPE.AMAP -> {
            }
        }
    }

    /**设置停车完成
     * @param complete true:完成 false:未完成
     */
    fun setParkComplete(complete: Boolean) {
        when (MSDKInitializer.getMapType()) {
            MAP_TYPE.MINE -> {
                var parkComplete = ParkComplete().apply {
                    this.complete = complete
                }
                UnityPlayer.UnitySendMessage(
                    MODELNAME,
                    "SetParkComplete",
                    gson.toJson(parkComplete)
                )
            }

            MAP_TYPE.AMAP -> {
            }
        }
    }


    /**设置车位停车状态*/
    fun setParkStatu(parkStatu: ParkStatu) {
        when (MSDKInitializer.getMapType()) {
            MAP_TYPE.MINE -> {
                UnityPlayer.UnitySendMessage(MODELNAME, "SetSpaceParkStatu", gson.toJson(parkStatu))
            }

            MAP_TYPE.AMAP -> {
            }
        }
    }


    /**设置地锁动画*/
    fun setLockStatus(lockStatu: LockStatu) {
        when (MSDKInitializer.getMapType()) {
            MAP_TYPE.MINE -> {
                UnityPlayer.UnitySendMessage(MODELNAME, "SetLockStatus", gson.toJson(lockStatu))
            }

            MAP_TYPE.AMAP -> {
            }
        }
    }

    // 小地图开关
    /*   fun showMap(showSmallMap: String) {
   //    fun showMap(showSmallMap: ShowSmallMap) {
           UnityPlayer.UnitySendMessage(MODELNAME, "showMap", showSmallMap)
   //        UnityPlayer.UnitySendMessage(MODELNAME, "showMap", gson.toJson(showSmallMap))
       }*/


}