package com.cusc.map.fragments

import android.graphics.Point
import android.os.Bundle
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import androidx.core.view.isVisible
import androidx.fragment.app.Fragment
import com.minedata.minenavi.map.MapPoiDetail
import com.minedata.minenavi.map.Marker
import com.minedata.minenavi.map.MineMap
import com.minedata.minenavi.map.Overlay
import com.minedata.minenavi.map.ScaleView
import com.minedata.minenavi.map.TrafficEventInfo
import com.minedata.minenavi.mapdal.LatLng
import com.minedata.minenavi.mapdal.NdsPoint
import com.minedata.minenavi.util.Tools
import com.cusc.map.UserCtx
import com.cusc.map.databinding.FragmentForeMapBinding
import com.cusc.map.location.MSLocCb
import com.cusc.map.ui.MapMultiView.OnMapReadyLis
import com.cusc.map.ui.MapReadyView

// the fragment initialization parameters, e.g. ARG_ITEM_NUMBER
//private const val ARG_PARAM1 = "param1"
//private const val ARG_PARAM2 = "param2"

/**
 *四维地图容器
 */
class ForeMapFragment : Fragment() {
//    private var param1: String? = null
//    private var param2: String? = null

//    override fun onCreate(savedInstanceState: Bundle?) {
//        super.onCreate(savedInstanceState)
//        arguments?.let {
//            param1 = it.getString(ARG_PARAM1)
//            param2 = it.getString(ARG_PARAM2)
//        }
//    }

    override fun onCreateView(
        inflater: LayoutInflater, container: ViewGroup?,
        savedInstanceState: Bundle?
    ): View {
        binding = FragmentForeMapBinding.inflate(inflater, container, false)
        // Inflate the layout for this fragment
        return binding.root
    }


    private lateinit var binding: FragmentForeMapBinding


    //跳转到搜索界面
    /*  private var searchAct =
          registerForActivityResult(ActivityResultContracts.StartActivityForResult(), { result ->
              if (result.resultCode == Activity.RESULT_OK) {
                  val intent = result.data
                  val returnedData = intent?.getStringExtra("123")
                  Log.d("----", "----Returned data: $returnedData")
              }
          })*/


    private var mMineMap: MineMap? = null

    private var onMapReadyLis: OnMapReadyLis? = null

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        super.onViewCreated(view, savedInstanceState)
        initView()
        binding.mapView.addMapRenderCallback { mineMap ->
            this.mMineMap = mineMap
            MapReadyView.instance.mMineMap = mineMap
            MapReadyView.instance.fMapView = binding.mapView
            UserCtx.instance.mapReadyView = MapReadyView.instance
            onMapReadyLis?.onMapReady(MapReadyView.instance)
            setListener(mineMap)
        }

    }

    private fun initView() {

    }

    private fun setListener(mineMap: MineMap) {
        binding.ivLocation.setOnClickListener {
            //定位到地图中心点
            var loc = MSLocCb.instance
            val point = Tools.latLngToPoint(LatLng(loc.lat, loc.lng))
            mMineMap?.setPointToCenter(point.x, point.y)
        }
        mineMap.addListener(object : MineMap.Listener {
            override fun onNeedsDisplay() {

            }

            override fun onMrWillBeginNewFrame() {

            }

            override fun onMarkerClicked(
                annot: Marker?,
                area: Int
            ) {

            }

            override fun onMarkerSelected(annot: Marker?) {

            }

            override fun onMarkerDeselected(annot: Marker?) {

            }

            override fun onOverlayClicked(overlay: Overlay?) {

            }

            override fun onOverlaySelected(
                overlay: Overlay?,
                grabbedPoint: Point?
            ) {

            }

            override fun onOverlaySelectedNds(
                overlay: Overlay?,
                grabbedPoint: NdsPoint?
            ) {

            }

            override fun onOverlayDeselected(overlay: Overlay?) {

            }

            override fun onPoiSelected(name: String?, pos: Point?) {

            }

            override fun onPoiDeselected(name: String?, pos: Point?) {

            }

            override fun onPoiSelectedNds(
                name: String?,
                pos: NdsPoint?
            ) {

            }

            override fun onPoiDeselectedNds(
                name: String?,
                pos: NdsPoint?
            ) {

            }

            override fun onPoiClicked(mapPoiDetail: MapPoiDetail?) {

            }

            override fun onCameraChanged(changeType: Int) {
                if (binding.compassView.isVisible) {
                    binding.compassView.updateHeading(mMineMap?.heading ?: 0f)
                }
                if (binding.scaleView.isVisible) {
                    binding.scaleView.updateScale(mMineMap?.zoomLevel ?: 3f)
                }
            }

            override fun onGestureAnimationEvent(animStarted: Boolean) {

            }

            override fun onCameraAnimationEnded() {

            }

            override fun onTileLoadingFinished() {

            }

            override fun onGridTypesLoaded(layerTypes: IntArray?) {

            }

            override fun onGridTypesReadyForDraw(layerTypes: IntArray?) {

            }

            override fun onOnlineDataVersionChecked(upgraded: Boolean) {

            }

            override fun onUserRasterDataUpdated(fromSource: Int) {

            }

            override fun onTrafficEventIconClicked(
                type: Int,
                trafficEventInfo: TrafficEventInfo?
            ) {

            }

            override fun onRouteExplorerLayerClicked(index: Int) {

            }
        })
    }

    /**地图加载完成监听回调*/
    fun addMapRenderCallback(onMapReadyLis: OnMapReadyLis) {
        this.onMapReadyLis = onMapReadyLis
    }

    fun getMineMap(): MineMap? {
        return mMineMap
    }

    override fun onPause() {
        super.onPause()
        binding.mapView.onPause()
    }

    override fun onResume() {
        super.onResume()
        binding.mapView.onResume()
    }

    override fun onDestroy() {
        super.onDestroy()
        binding.mapView.onDestroy()
    }

    //指南针
    fun setCompassView(bool: Boolean) {
        binding.compassView.visibility = if (bool) View.VISIBLE else View.GONE
        binding.compassView.setMapView(binding.mapView)
    }

    //比例尺
    fun setScaleControlsEnabled(bool: Boolean) {
        binding.scaleView.visibility = if (bool) View.VISIBLE else View.GONE
        binding.scaleView.setMapView(binding.mapView)
        binding.scaleView.setDrawPos(ScaleView.Pos.leftBottom)
    }

    //显示我的位置中心点
    fun setMyLocationButtonEnabled(bool: Boolean) {
        binding.ivLocation.visibility = if (bool) View.VISIBLE else View.GONE
    }

    companion object {
        @JvmStatic
        fun newInstance() = ForeMapFragment()

//        @JvmStatic
//        fun newInstance(param1: String, param2: String) =
//            ForeMapFragment().apply {
//                arguments = Bundle().apply {
//                    putString(ARG_PARAM1, param1)
//                    putString(ARG_PARAM2, param2)
//                }
//            }
    }


}