package com.cusc.map.fragments

import android.os.Bundle
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import androidx.fragment.app.Fragment
import com.amap.api.maps.AMap
import com.cusc.map.UserCtx
import com.cusc.map.databinding.FragmentAMapBinding
import com.cusc.map.ui.MapReadyView
import com.cusc.map.ui.MapMultiView.OnMapReadyLis


// the fragment initialization parameters, e.g. ARG_ITEM_NUMBER
//private const val ARG_PARAM1 = "param1"
//private const val ARG_PARAM2 = "param2"

/**
 * 高德地图
 */
class AMapFragment : Fragment() {
//    private var param1: String? = null
//    private var param2: String? = null

//    override fun onCreate(savedInstanceState: Bundle?) {
//        super.onCreate(savedInstanceState)
//        arguments?.let {
//            param1 = it.getString(ARG_PARAM1)
//            param2 = it.getString(ARG_PARAM2)
//        }
//    }

    lateinit var binding: FragmentAMapBinding

    override fun onCreateView(
        inflater: LayoutInflater, container: ViewGroup?,
        savedInstanceState: Bundle?
    ): View? {
        // Inflate the layout for this fragment
        binding = FragmentAMapBinding.inflate(inflater, container, false)
        return binding.root
    }

    private lateinit var aMap: AMap

    private var onMapReadyLis: OnMapReadyLis? = null

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        super.onViewCreated(view, savedInstanceState)
        binding.mMapView.onCreate(savedInstanceState)
        aMap = binding.mMapView.map
        MapReadyView.instance.aMap = aMap
        UserCtx.instance.mapReadyView = MapReadyView.instance
        onMapReadyLis?.onMapReady(MapReadyView.instance)
        setListener()
    }

    private fun setListener() {
        binding.ivLocation.setOnClickListener {
            aMap.isMyLocationEnabled = !aMap.isMyLocationEnabled
        }
    }

    fun addMapRenderCallback(onMapReadyLis: OnMapReadyLis) {
        this.onMapReadyLis = onMapReadyLis
    }

    fun getAnyMap(): Any? {
        return aMap
    }


    override fun onResume() {
        super.onResume()
        binding.mMapView.onResume()
    }

    override fun onPause() {
        super.onPause()
        binding.mMapView.onPause()
    }

    override fun onSaveInstanceState(outState: Bundle) {
        super.onSaveInstanceState(outState)
        binding.mMapView.onSaveInstanceState(outState)
    }

    override fun onDestroy() {
        super.onDestroy()
        binding.mMapView.onDestroy()
    }

    fun setCompassView(bool: Boolean) {
        var mUiSettings = aMap.getUiSettings()
        mUiSettings.isCompassEnabled = bool
    }

    fun setScaleControlsEnabled(bool: Boolean) {
        var mUiSettings = aMap.getUiSettings()
        mUiSettings.isScaleControlsEnabled = bool
    }

    fun setMyLocationButtonEnabled(bool: Boolean) {
//        var mUiSettings = aMap.getUiSettings()
//        mUiSettings.setMyLocationButtonEnabled(bool) //显示默认的定位按钮
        binding.ivLocation.visibility = if (bool) View.VISIBLE else View.GONE
//        aMap.setMyLocationEnabled(bool)// 可触发定位并显示当前位置
    }


    companion object {

        @JvmStatic
        fun newInstance() = AMapFragment()

//        @JvmStatic
//        fun newInstance(param1: String, param2: String) =
//            AMapFragment().apply {
//                arguments = Bundle().apply {
//                    putString(ARG_PARAM1, param1)
//                    putString(ARG_PARAM2, param2)
//                }
//            }
    }
}