package com.cusc.map


//@Target(AnnotationTarget.CLASS, AnnotationTarget.FUNCTION,
//    AnnotationTarget.TYPE_PARAMETER, AnnotationTarget.VALUE_PARAMETER,
//    AnnotationTarget.EXPRESSION)
@Target(AnnotationTarget.CLASS, AnnotationTarget.FUNCTION)
@Retention(AnnotationRetention.RUNTIME)
@MustBeDocumented
annotation class Ann(val s1: String, val i: Int)


@Target(AnnotationTarget.VALUE_PARAMETER)
@Retention(AnnotationRetention.RUNTIME)
@MustBeDocumented
annotation class Field(val s1: String)

@Target(AnnotationTarget.VALUE_PARAMETER)
@Retention(AnnotationRetention.RUNTIME)
@MustBeDocumented
annotation class QField(val s2: String)


@Ann(s1 = "123", i = -1)
class MyTest {


    fun addRoute(@Field(s1 = "111") @QField(s2 = "555") url: String) {

    }

}

fun main() {
    var myTest = MyTest()
    var cls = myTest.javaClass
    var methods = cls.declaredMethods
    methods.forEach { method ->
        //获取方法上的所有的注解
        var methodAnnotations = method.getAnnotations();
        //获得方法参数的所有的注解 (一个参数可以有多个注解,一个方法又会有多个参数)
        var parameterAnnotations = method.getParameterAnnotations();
        parameterAnnotations.forEachIndexed { index, annotations ->
            // 一个参数上的所有的注解
            val annotations = parameterAnnotations[index]
            annotations.forEach {
                if (it is Field){
                    println("---- = ${it.s1}")
                }else if (it is QField){
                    println("---- = ${it.s2}")
                }
            }

        }

        var a=0
    }
//    var annts=cls.annotations
//    annts.forEach {
//            it->
//        if (it is Ann){
//            println("------it = ${it}")
//        }
//    }
}