import org.intellij.markdown.html.urlEncode
import org.jetbrains.dokka.DokkaConfiguration
import org.jetbrains.dokka.DokkaConfiguration.Visibility
import org.jetbrains.dokka.DokkaDefaults
import org.jetbrains.dokka.DokkaDefaults.skipEmptyPackages
import org.jetbrains.dokka.base.DokkaBase
import org.jetbrains.dokka.base.DokkaBaseConfiguration
import org.jetbrains.dokka.gradle.DokkaTask
import org.jetbrains.kotlin.gradle.targets.js.npm.includedRange
import org.jetbrains.kotlin.psi.namedFunctionVisitor
import org.jetbrains.kotlin.psi.packageDirectiveVisitor

plugins {
    alias(libs.plugins.android.library)
    alias(libs.plugins.kotlin.android)
    id("kotlin-kapt")
    id("kotlin-parcelize")
//    id("maven-publish")
//    signing
//    id ("org.jreleaser") version "1.20.0"//JReleaser now has support for publishing via the Central Publisher Portal and can be used via their Gradle plugin integration.
//    id("org.jetbrains.dokka") version "2.0.0"
//    kotlin("jvm") version "2.1.10"
    id("org.jetbrains.dokka") version "2.0.0"
}


android {
    namespace = "com.cusc.map"
    compileSdk = 35

    defaultConfig {
        minSdk = 29
        version = "1.0.0"

        testInstrumentationRunner = "androidx.test.runner.AndroidJUnitRunner"
        consumerProguardFiles("consumer-rules.pro")
    }

    buildTypes {
        release {
            isMinifyEnabled = false
            proguardFiles(
                getDefaultProguardFile("proguard-android-optimize.txt"),
                "proguard-rules.pro"
            )
        }
    }
    compileOptions {
        sourceCompatibility = JavaVersion.VERSION_11
        targetCompatibility = JavaVersion.VERSION_11
    }
    kotlinOptions {
        jvmTarget = "11"
    }
    buildFeatures {
//        dataBinding = true
        viewBinding = true
    }
    android.libraryVariants.all {
        outputs.all {
            if (this is com.android.build.gradle.internal.api.LibraryVariantOutputImpl) {
//                        val config = project.android.defaultConfig
//                        val versionName = config.versionName
//               val formatter = DateTimeFormatter.ofPattern("yyyy_MM_dd_HHmm")
//               val createTime = LocalDateTime.now().format(formatter)
                outputFileName = "map_cusc_${version}.aar"
            }
        }
    }
}


dependencies {
    implementation(fileTree(mapOf("dir" to "libs", "include" to listOf("*.jar", "*.aar"))))
    implementation(libs.androidx.core.ktx)
    implementation(libs.androidx.appcompat)
    implementation(libs.material)
    implementation(libs.androidx.constraintlayout)
    implementation(libs.androidx.activity)
    testImplementation(libs.junit)
    androidTestImplementation(libs.androidx.junit)
    androidTestImplementation(libs.androidx.espresso.core)

    // Is applied for the single-module dokkaHtml task only
//    dokkaHtmlPlugin("org.jetbrains.dokka:kotlin-as-java-plugin:2.0.0")
    // Will apply the plugin to all Dokka tasks
    dokkaPlugin("org.jetbrains.dokka:kotlin-as-java-plugin:2.0.0")
//    dokka("org.jetbrains.dokka:kotlin-as-java-plugin:2.0.0")


    api(project(":maplibs"))
//    Webview交互
    api("com.github.lzyzsd:jsbridge:1.0.4")

    //四维高精地图依赖
//    implementation("daohang.tingche.unityLibrary:adas:1.0")

    //高德
//    implementation("com.amap.api:navi-3dmap:latest.integration")
//    implementation("com.amap.api:search:latest.integration")
    //网络
    implementation("com.squareup.okhttp3:okhttp:3.12.0")
    implementation("com.google.code.gson:gson:2.8.6")
    // 权限请求框架
    implementation("com.guolindev.permissionx:permissionx:1.8.1")
    // ViewModel
    implementation("androidx.lifecycle:lifecycle-viewmodel-ktx:2.6.2")
    //fragment-ktx
    implementation("androidx.fragment:fragment-ktx:1.8.0")
}

dokka {
//    moduleName.set("Project Name")
    dokkaPublications.html {
        suppressInheritedMembers.set(true)
        failOnWarning.set(true)
        includes.setFrom("com.cusc.map.maps")

    }
    dokkaSourceSets.main {
//        includes.from("README.md")
//        sourceLink {
//            localDirectory.set(file("src/main/kotlin"))
//            remoteUrl("https://example.com/src")
//            remoteLineSuffix.set("#L")
//        }
    }
    dokkaSourceSets.configureEach {
        perPackageOption {
            matchingRegex.set("^com.cusc.map.maps.*")
//            includedRange("com.sd.api.maps")
        }
    }
    pluginsConfiguration.html {
//        customStyleSheets.from("styles.css")
//        customAssets.from("logo.png")
//        footerMessage.set("(c) Your Company")
    }
}



//group = "msmap"
//version = "1.0"


//publishing {
//    publications {
//        create<MavenPublication>("maplib") {
//            groupId = "io.github.killcow"
//            artifactId = "ms-map"
//            version = "1.0.0"
//
//            // 如果是Android库模块
//            artifact(layout.buildDirectory.dir("outputs/aar/maplibrary-release.aar"))
//            // 如果是Java库模块
//            // artifact("$buildDir/libs/your-library.jar")
//            //发布到本地仓库
//            repositories {
//                maven {
//                    name = "MyRepo"
//                    url = uri(layout.buildDirectory.dir("repo"))
//                }
//
//            }
//        }
//    }
//}

//signing {
////    val signingKey: String=findProperty("signing.keyId")
//    val signingPassword: String? by project
//    useInMemoryPgpKeys(findProperty("signing.keyId").toString(), findProperty("signing.password").toString())
////
//    sign(publishing.publications["maplib"])
//}


