package com.sd.demo.ui

//import com.sd.maplibrary.core.MSRoutePlans
//import com.sd.maplibrary.core.MSRoutePlans.OnDriveRoute
import android.os.Bundle
import androidx.appcompat.app.AppCompatActivity
import com.minedata.minenavi.mapdal.NativeEnv
import com.minedata.minenavi.mapdal.NdsPoint
import com.minedata.minenavi.navi.GuidanceText
import com.minedata.minenavi.navi.NaviProgressData
import com.minedata.minenavi.navi.SmoothNaviData
import com.minedata.minenavi.navi.TmcSections
import com.minedata.minenavi.util.Tools
import com.sd.api.bean.DriverRouteBean
import com.sd.api.bean.WayPoi
import com.sd.api.intfaces.OnNaviPresenterListener
import com.sd.api.maps.MSNavi
import com.sd.api.maps.MSRoutePlans
import com.sd.api.maps.cdata.MSLatLng
import com.sd.api.maps.inters.OnDriveRoute
import com.sd.api.maps.mine.MineNai
import com.sd.api.maps.mine.MineRoutePlans
import com.sd.api.ui.MapMultiView.OnMapReadyLis
import com.sd.api.ui.MapReadyView
import com.sd.demo.databinding.ActivityTdriveRouteBinding


/***驾车路径规划***/
class TDriveRouteActivity : AppCompatActivity(), OnNaviPresenterListener {

    private lateinit var binding: ActivityTdriveRouteBinding

    var mapReadView: MapReadyView? = null

    var driverRouteBean: DriverRouteBean? = null

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        binding = ActivityTdriveRouteBinding.inflate(layoutInflater)
        setContentView(binding.root)

        binding.mapMultiView.addMapRenderCallback(object : OnMapReadyLis {
            override fun onMapReady(mapReadyView: MapReadyView) {
                this@TDriveRouteActivity.mapReadView = mapReadyView
            }
        })
        //开始路径规划
        binding.starplan.setOnClickListener {
            if (mapReadView == null) return@setOnClickListener
            // 起点坐标
            val startPoint = MSLatLng(39.80715003487552, 116.49872416608724)//
            // 终点坐标
            val endPoint = MSLatLng(39.80841750846264, 116.49490649028968)
            // 终点名称
//            val endName = "沈阳火车站"
            val endName = "林肯公园B区"
//            var wayPoi1 = WayPoi(
//                passName = "中国联通软件研究院", passPoint = MSLatLng(39.809395470467024,116.50205317087261)
//            )
            //途经点
            var wayPoi = WayPoi(
                passName = "中国联通软件研究院",
                passPoint = MSLatLng(39.808099975017825, 116.50229613984811)
            )
            var ways = listOf<WayPoi>(wayPoi)

            //开始路径规划
            MSRoutePlans.drivingPathPlanning(
                startPoint,
                "当前位置",
                endPoint,
                endName,
                ways,
                object : OnDriveRoute {
                    override fun onDriverRoute(driverRouteBean: DriverRouteBean) {
                        this@TDriveRouteActivity.driverRouteBean = driverRouteBean
                        var mRouteBase = driverRouteBean.routeBase
                        var size = mRouteBase?.segmentNumber ?: 0
                        if (size > 2) {
                            var pos = mutableListOf<MSLatLng>()
                            for (i in 0 until size) {
                                var pointArr = mRouteBase!!.getSegmentFinePoints(i)
                                var points = pointArr.map {
                                    var po = Tools.pointToLatLng(it)
                                    var ms = MSLatLng(po.latitude, po.longitude)
                                    return@map ms
                                }
                                pos.addAll(points)
                            }
//                            lifecycleScope.launch {
//                                FileIoUtils.writeToFile(Gson().toJson(pos), "troute.txt")
//                            }
                        }
                    }
                }
            )
//            MSRoutePlans.drivingPathPlanning(startPoint, endPoint, ways, endName)

//            testDriverPlan()
//            testDriverPlanaMAP()
        }

        //导航对象初始化
        MSNavi.init()
        //直接开始导航
        binding.starnai.setOnClickListener {
            if (mapReadView == null) return@setOnClickListener

            // 起点坐标 116.3215,39.8919
            val startPoint = MSLatLng(39.806898, 116.490682)
            // 终点坐标116.3793,39.8643
            val endPoint = MSLatLng(39.864311, 116.379311)
            // 终点名称
            val endName = "沈阳火车站"
            //途经点
            var wayPoi = WayPoi(
                passName = "鸟巢", passPoint = MSLatLng(39.99300, 116.39524)
            )
            var ways = listOf<WayPoi>(wayPoi)

            MSNavi.startNavi(
                mapReadView,
                2/*1=自己实现回调 2=直接调用导航组件*/,
                startPoint,
                "当前位置",
                endPoint,
                endName,
                ways,
                this
            )
        }
        //模拟导航
        binding.simnai.setOnClickListener {
            // 起点坐标
            val startPoint = MSLatLng(39.80715003487552, 116.49872416608724)
            MSNavi.startSimNavi(
                this@TDriveRouteActivity.mapReadView,
                startPoint,
                driverRouteBean,
                this
            )
        }
        //退出导航
        binding.stopnai.setOnClickListener {
            MSNavi.endNavi()
        }
    }

    /**
     * 刷新导航中的自车位置
     */
    fun showNavingCarPosition(ndsPoint: NdsPoint?, heading: Float) {
        synchronized(NativeEnv.SyncObject) {
            if (ndsPoint == null) {
                return
            }
            var mMapCar = MineNai.mMapCar
            mMapCar?.setPositionNds(Tools.ndsPointToLatLng(ndsPoint))
            mMapCar?.setHeading(heading)
        }
    }


    /*   参考DEMO https://gitee.com/cennavi_sy/MineNaviDemo.git
       中的 app/src/main/java/com/cennavi/minenavidemo/activity/navi/NaviActivity.java
       和 app/src/main/java/com/cennavi/minenavidemo/presenter/NaviPresenter.java*/

    //车位置发生改变
    override fun onTracking(ratio: Float) {
    }

    //导航或者模拟导航时平滑跟踪
    override fun onSmoothTracking(data: SmoothNaviData) {
        println("------------TDriveRouteActivity.onSmoothTracking")
        val carHeading =
            if (data != null) data.carHeading else MineRoutePlans.mRouteBase!!.getStartDirection()
                .toFloat()
        val mapHeading = if (data != null) data.mapHeading else 0f
        var mineMap = mapReadView?.mMineMap

        showNavingCarPosition(data.carPos, carHeading)
        mineMap?.setHeading(mapHeading)
        mineMap?.setNdsPointToCenter(data.carPos.x, data.carPos.y)
    }

    //解析 naviProgressData 导航更新信息
    override fun onDataUpdated(naviProgressData: NaviProgressData) {
    }

    //解析 tmcSections 路况(TMC) 信息条中的段信息
    override fun onTiBarUpdated(tmcSections: TmcSections) {
    }

    //解析 guidanceText 引导文字信息
    override fun onTextChanged(guidanceText: GuidanceText) {
    }

    //导航路口剩余距离
    override fun onDistanceChanged(distance: Int) {
    }

    //导航路口剩余距离 目前是没有下一个引导点，距离路线距离10米，即为到达目的地。 有下一个引导点，下一个引导距此引导点距离在10米以内，到此引导距离在3米以内，也为到达目的地
    override fun onArriveDestination() {
    }

    //导航结束
    override fun onNaviEnded() {
    }

    //算路结果回调
    /*    private var onDriveRoute = object : OnDriveRoute {
            override fun onDriverRoute(driverRouteBean: DriverRouteBean) {
                MSRoutePlans.drawPlanPath(
                    mapReadView,
                    driverRouteBean
                )
            }
        }*/


}