package com.sd.demo.ui

import android.os.Bundle
import androidx.appcompat.app.AppCompatActivity
import com.sd.api.ui.MapReadyView
import com.sd.api.maps.DelDrawInMap
import com.sd.api.maps.cdata.MSOverlay
import com.sd.api.maps.DrawInMap
import com.sd.api.maps.MsCircleOptions
import com.sd.api.maps.cdata.MSLatLng
import com.sd.api.ui.MapMultiView.OnMapReadyLis
import com.sd.demo.databinding.ActivityTcircelBinding

/***绘制圆形**/
class TCircelActivity : AppCompatActivity() {

    private lateinit var binding: ActivityTcircelBinding

    var mapReadView: MapReadyView? = null

    //圆形覆盖物对象
    private var mSOverlay: MSOverlay? = null

    //获取接口功能实例
//    var mapCoreApi = MapCoreApi.mapCoreApi

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        binding = ActivityTcircelBinding.inflate(layoutInflater)
        setContentView(binding.root)

        binding.mapMultiView.addMapRenderCallback(object : OnMapReadyLis {
            override fun onMapReady(mapReadyView: MapReadyView) {
                this@TCircelActivity.mapReadView = mapReadyView

                //绘制一个圆形 116.3975,39.9079
                var center = MSLatLng(39.9079, 116.3975)
                //构造圆形绘制选型
                var msCircleOptions = MsCircleOptions()
                mSOverlay = DrawInMap.drawCircle(center, msCircleOptions)
            }
        })

        //删除圆形
        binding.bt1.setOnClickListener {
            //删除圆形
            DelDrawInMap.deleteCircle(mSOverlay)
        }

    }


}