/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.idst.nui;

import android.util.Log;
import com.alibaba.idst.nui.AsrResult;
import com.alibaba.idst.nui.CommonUtils;
import com.alibaba.idst.nui.Constants;
import com.alibaba.idst.nui.INativeFileTransCallback;
import com.alibaba.idst.nui.INativeNuiCallback;
import com.alibaba.idst.nui.INativeTtsCallback;
import com.alibaba.idst.nui.KwsResult;

public class NativeNui {
    private static final String TAG = "NativeNui_JAVA";
    private static NativeNui nui_;
    private INativeNuiCallback callback;
    private INativeFileTransCallback file_trans_callback;
    private boolean mInit = false;
    private long handle = 0L;
    private long tts_handle = 0L;
    private static boolean soLoadedInThisClassLoader;
    private Constants.ModeType mModeType = Constants.ModeType.MODE_DIALOG;
    private INativeTtsCallback tts_callback;

    private synchronized void CheckHandle() {
        if (this.handle == 0L) {
            this.handle = this.native_get_new_nui();
        }
    }

    private synchronized void CheckTtsHandle() {
        if (this.tts_handle == 0L) {
            this.tts_handle = this.native_get_new_nui_tts();
        }
    }

    public static synchronized NativeNui GetInstance() {
        if (nui_ == null) {
            nui_ = new NativeNui();
        }
        return nui_;
    }

    public NativeNui(Constants.ModeType modeType) {
        if (!soLoadedInThisClassLoader) {
            Log.e((String)TAG, (String)"library is not loaded");
            return;
        }
        if (modeType == Constants.ModeType.MODE_TTS) {
            this.tts_handle = this.native_get_new_nui_tts();
            new StringBuilder("nui tts handle = ").append(this.tts_handle);
        } else {
            this.handle = this.native_get_new_nui();
            new StringBuilder("nui handle = ").append(this.handle);
        }
        this.mModeType = modeType;
    }

    public NativeNui() {
        if (!soLoadedInThisClassLoader) {
            Log.e((String)TAG, (String)"library is not loaded");
            return;
        }
        this.handle = this.native_get_new_nui();
        new StringBuilder("nui handle = ").append(this.handle);
    }

    protected void finalize() {
        this.release();
    }

    public synchronized int initialize(INativeNuiCallback iNativeNuiCallback, String string2, Constants.LogLevel logLevel, boolean bl2) {
        if (!soLoadedInThisClassLoader) {
            Log.e((String)TAG, (String)"library is not loaded");
            return 999999;
        }
        this.callback = iNativeNuiCallback;
        this.CheckHandle();
        string2 = CommonUtils.fillHardwareInfo(string2);
        NativeNui nativeNui = this;
        return nativeNui.native_init(nativeNui.handle, string2, Constants.LogLevel.toInt(logLevel), bl2);
    }

    public synchronized int initialize(INativeNuiCallback iNativeNuiCallback, String string2, Constants.LogLevel logLevel) {
        if (!soLoadedInThisClassLoader) {
            Log.e((String)TAG, (String)"library is not loaded");
            return 999999;
        }
        this.callback = iNativeNuiCallback;
        this.CheckHandle();
        string2 = CommonUtils.fillHardwareInfo(string2);
        NativeNui nativeNui = this;
        return nativeNui.native_init(nativeNui.handle, string2, Constants.LogLevel.toInt(logLevel), false);
    }

    public synchronized int initialize(INativeFileTransCallback iNativeFileTransCallback, String string2, Constants.LogLevel logLevel) {
        if (!soLoadedInThisClassLoader) {
            Log.e((String)TAG, (String)"library is not loaded");
            return 999999;
        }
        this.file_trans_callback = iNativeFileTransCallback;
        this.CheckHandle();
        string2 = CommonUtils.fillHardwareInfo(string2);
        NativeNui nativeNui = this;
        return nativeNui.native_init(nativeNui.handle, string2, Constants.LogLevel.toInt(logLevel), false);
    }

    public synchronized int release() {
        if (!soLoadedInThisClassLoader) {
            Log.e((String)TAG, (String)"library is not loaded");
            return 999999;
        }
        this.CheckHandle();
        NativeNui nativeNui = this;
        nativeNui.native_release(nativeNui.handle);
        this.handle = 0L;
        return 0;
    }

    public synchronized int startDialog(Constants.VadMode vadMode, String string2) {
        if (!soLoadedInThisClassLoader) {
            Log.e((String)TAG, (String)"library is not loaded");
            return 999999;
        }
        this.CheckHandle();
        NativeNui nativeNui = this;
        return nativeNui.native_start_dialog(nativeNui.handle, vadMode.getCode(), string2);
    }

    public synchronized int cancelDialog() {
        if (!soLoadedInThisClassLoader) {
            Log.e((String)TAG, (String)"library is not loaded");
            return 999999;
        }
        this.CheckHandle();
        NativeNui nativeNui = this;
        return nativeNui.native_cancel_dialog(nativeNui.handle, true);
    }

    public synchronized int resumeDialog() {
        if (!soLoadedInThisClassLoader) {
            Log.e((String)TAG, (String)"library is not loaded");
            return 999999;
        }
        this.CheckHandle();
        NativeNui nativeNui = this;
        return nativeNui.native_resume_dialog(nativeNui.handle);
    }

    public synchronized int stopDialog() {
        if (!soLoadedInThisClassLoader) {
            Log.e((String)TAG, (String)"library is not loaded");
            return 999999;
        }
        this.CheckHandle();
        NativeNui nativeNui = this;
        return nativeNui.native_cancel_dialog(nativeNui.handle, false);
    }

    public synchronized int startText2Action(boolean bl2, String string2, String string3, String string4) {
        if (!soLoadedInThisClassLoader) {
            Log.e((String)TAG, (String)"library is not loaded");
            return 999999;
        }
        new StringBuilder("start Text2Action with text=").append(string2).append(" context=").append(string3).append(" dialog_param=").append(string4);
        this.CheckHandle();
        NativeNui nativeNui = this;
        return nativeNui.native_start_text_dialog(nativeNui.handle, bl2, string2, string3, string4);
    }

    public synchronized int setParams(String string2) {
        if (!soLoadedInThisClassLoader) {
            Log.e((String)TAG, (String)"library is not loaded");
            return 999999;
        }
        this.CheckHandle();
        NativeNui nativeNui = this;
        return nativeNui.native_set_params(nativeNui.handle, string2);
    }

    public synchronized int setParam(String string2, String string3) {
        if (!soLoadedInThisClassLoader) {
            Log.e((String)TAG, (String)"library is not loaded");
            return 999999;
        }
        new StringBuilder("set param with para ").append(string2).append(" value ").append(string3);
        this.CheckHandle();
        NativeNui nativeNui = this;
        return nativeNui.native_set_param(nativeNui.handle, string2, string3);
    }

    public synchronized int updateAudio(byte[] byArray, int n2, boolean bl2) {
        if (!soLoadedInThisClassLoader) {
            Log.e((String)TAG, (String)"library is not loaded");
            return 999999;
        }
        this.CheckHandle();
        NativeNui nativeNui = this;
        return nativeNui.native_update_audio(nativeNui.handle, byArray, n2, bl2);
    }

    public synchronized String GetVersion() {
        if (!soLoadedInThisClassLoader) {
            Log.e((String)TAG, (String)"library is not loaded");
            return "library is not loaded";
        }
        this.CheckHandle();
        NativeNui nativeNui = this;
        return nativeNui.native_get_version(nativeNui.handle);
    }

    public synchronized int registeruserVpr(String string2, String string3, String string4) {
        if (!soLoadedInThisClassLoader) {
            Log.e((String)TAG, (String)"library is not loaded");
            return 999999;
        }
        this.CheckHandle();
        NativeNui nativeNui = this;
        return nativeNui.native_vpr_register_user(nativeNui.handle, string2, string3, string4);
    }

    public synchronized int updateuserVpr(String string2, String string3, String string4) {
        if (!soLoadedInThisClassLoader) {
            Log.e((String)TAG, (String)"library is not loaded");
            return 999999;
        }
        this.CheckHandle();
        NativeNui nativeNui = this;
        return nativeNui.native_vpr_update_user(nativeNui.handle, string2, string3, string4);
    }

    public synchronized int deleteuserVpr(String string2, String string3, String string4) {
        if (!soLoadedInThisClassLoader) {
            Log.e((String)TAG, (String)"library is not loaded");
            return 999999;
        }
        this.CheckHandle();
        NativeNui nativeNui = this;
        return nativeNui.native_vpr_delete_user(nativeNui.handle, string2, string3, string4);
    }

    public synchronized int enableVpr() {
        if (!soLoadedInThisClassLoader) {
            Log.e((String)TAG, (String)"library is not loaded");
            return 999999;
        }
        this.CheckHandle();
        NativeNui nativeNui = this;
        return nativeNui.native_vpr_enable(nativeNui.handle);
    }

    public synchronized int disableVpr() {
        if (!soLoadedInThisClassLoader) {
            Log.e((String)TAG, (String)"library is not loaded");
            return 999999;
        }
        this.CheckHandle();
        NativeNui nativeNui = this;
        return nativeNui.native_vpr_disable(nativeNui.handle);
    }

    public synchronized int registercancelVpr() {
        if (!soLoadedInThisClassLoader) {
            Log.e((String)TAG, (String)"library is not loaded");
            return 999999;
        }
        this.CheckHandle();
        NativeNui nativeNui = this;
        return nativeNui.native_vpr_register_cancel(nativeNui.handle);
    }

    public synchronized int startFileTranscriber(String string2, byte[] byArray) {
        if (!soLoadedInThisClassLoader) {
            Log.e((String)TAG, (String)"library is not loaded");
            return 999999;
        }
        this.CheckHandle();
        NativeNui nativeNui = this;
        return nativeNui.native_file_trans_start(nativeNui.handle, string2, byArray);
    }

    public synchronized int cancelFileTranscriber(String string2) {
        if (!soLoadedInThisClassLoader) {
            Log.e((String)TAG, (String)"library is not loaded");
            return 999999;
        }
        this.CheckHandle();
        NativeNui nativeNui = this;
        return nativeNui.native_file_trans_cancel(nativeNui.handle, string2);
    }

    private native long native_get_new_nui();

    private native int native_init(long var1, String var3, int var4, boolean var5);

    private native int native_start_dialog(long var1, int var3, String var4);

    private native int native_cancel_dialog(long var1, boolean var3);

    private native int native_release(long var1);

    private native int native_resume_dialog(long var1);

    private native String native_get_version(long var1);

    private native int native_start_text_dialog(long var1, boolean var3, String var4, String var5, String var6);

    private native int native_set_params(long var1, String var3);

    private native int native_set_param(long var1, String var3, String var4);

    private native int native_file_trans_start(long var1, String var3, byte[] var4);

    private native int native_file_trans_cancel(long var1, String var3);

    private native int native_update_audio(long var1, byte[] var3, int var4, boolean var5);

    private native int native_vpr_register_user(long var1, String var3, String var4, String var5);

    private native int native_vpr_update_user(long var1, String var3, String var4, String var5);

    private native int native_vpr_delete_user(long var1, String var3, String var4, String var5);

    private native int native_vpr_enable(long var1);

    private native int native_vpr_disable(long var1);

    private native int native_vpr_register_cancel(long var1);

    private native boolean native_monkey_test_start(String var1, String var2, String var3, String var4, String var5, String var6, int var7, int var8);

    private native boolean native_monkey_test_stop();

    private void onNuiEventCallback_(int n2, int n3, int n4, KwsResult kwsResult, AsrResult asrResult) {
        if (this.callback != null) {
            if (asrResult != null) {
                new StringBuilder("native isfinish ").append(asrResult.finish).append(";asr_result:").append(asrResult.asrResult);
            }
            this.callback.onNuiEventCallback(Constants.NuiEvent.values()[n2], n3, n4, kwsResult, asrResult);
            return;
        }
        Log.e((String)TAG, (String)"callback is null");
    }

    private void onFileTransEventCallback_(int n2, int n3, int n4, AsrResult asrResult, byte[] byArray) {
        if (this.file_trans_callback != null) {
            if (asrResult != null) {
                new StringBuilder("native isfinish ").append(asrResult.finish).append(";asr_result:").append(asrResult.asrResult).append(";task_id:").append(new String(byArray));
            }
            this.file_trans_callback.onFileTransEventCallback(Constants.NuiEvent.values()[n2], n3, n4, asrResult, new String(byArray));
            return;
        }
        Log.e((String)TAG, (String)"callback is null");
    }

    private int onNuiNeedAudioData_(byte[] byArray, int n2) {
        if (this.callback != null) {
            return this.callback.onNuiNeedAudioData(byArray, n2);
        }
        return -1;
    }

    private void onNuiAudioStateChanged_(int n2) {
        if (this.callback != null) {
            this.callback.onNuiAudioStateChanged(Constants.AudioState.values()[n2]);
        }
    }

    private void onNuiRMSChanged_(float f2) {
        if (this.callback != null) {
            this.callback.onNuiAudioRMSChanged(f2);
        }
    }

    private void onNuiVprEventCallback_(int n2) {
        if (this.callback != null) {
            this.callback.onNuiVprEventCallback(Constants.NuiVprEvent.fromInt(n2));
        }
    }

    private native long native_get_new_nui_tts();

    private native int native_tts_init(long var1, String var3, int var4, boolean var5);

    private native int native_tts_release(long var1);

    private native int native_tts_play(long var1, String var3, String var4, String var5);

    private native int native_tts_cancel(long var1, String var3);

    private native int native_tts_pause(long var1);

    private native int native_tts_resume(long var1);

    private native int native_tts_set_param(long var1, String var3, String var4);

    private native String native_tts_get_param(long var1, String var3);

    private native int native_get_num_of_chars(long var1, String var3);

    public synchronized int tts_initialize(INativeTtsCallback iNativeTtsCallback, String string2, Constants.LogLevel logLevel, boolean bl2) {
        if (!soLoadedInThisClassLoader) {
            Log.e((String)TAG, (String)"library is not loaded");
            return 999999;
        }
        this.tts_callback = iNativeTtsCallback;
        this.CheckTtsHandle();
        new StringBuilder("tts-handle:").append(this.tts_handle);
        string2 = CommonUtils.fillHardwareInfo(string2);
        NativeNui nativeNui = this;
        return nativeNui.native_tts_init(nativeNui.tts_handle, string2, Constants.LogLevel.toInt(logLevel), bl2);
    }

    public synchronized int tts_release() {
        if (!soLoadedInThisClassLoader) {
            Log.e((String)TAG, (String)"library is not loaded");
            return 999999;
        }
        this.callback = null;
        this.CheckTtsHandle();
        NativeNui nativeNui = this;
        int n2 = nativeNui.native_tts_release(nativeNui.tts_handle);
        this.tts_handle = 0L;
        return n2;
    }

    public synchronized int startTts(String string2, String string3, String string4) {
        if (!soLoadedInThisClassLoader) {
            Log.e((String)TAG, (String)"library is not loaded");
            return 999999;
        }
        this.CheckTtsHandle();
        NativeNui nativeNui = this;
        return nativeNui.native_tts_play(nativeNui.tts_handle, string2, string3, string4);
    }

    public synchronized int cancelTts(String string2) {
        if (!soLoadedInThisClassLoader) {
            Log.e((String)TAG, (String)"library is not loaded");
            return 999999;
        }
        this.CheckTtsHandle();
        NativeNui nativeNui = this;
        return nativeNui.native_tts_cancel(nativeNui.tts_handle, string2);
    }

    public synchronized int pauseTts() {
        if (!soLoadedInThisClassLoader) {
            Log.e((String)TAG, (String)"library is not loaded");
            return 999999;
        }
        this.CheckTtsHandle();
        NativeNui nativeNui = this;
        return nativeNui.native_tts_pause(nativeNui.tts_handle);
    }

    public synchronized int resumeTts() {
        if (!soLoadedInThisClassLoader) {
            Log.e((String)TAG, (String)"library is not loaded");
            return 999999;
        }
        this.CheckTtsHandle();
        NativeNui nativeNui = this;
        return nativeNui.native_tts_resume(nativeNui.tts_handle);
    }

    public synchronized int setparamTts(String string2, String string3) {
        if (!soLoadedInThisClassLoader) {
            Log.e((String)TAG, (String)"library is not loaded");
            return 999999;
        }
        new StringBuilder("param:").append(string2).append("; value:").append(string3);
        this.CheckTtsHandle();
        NativeNui nativeNui = this;
        return nativeNui.native_tts_set_param(nativeNui.tts_handle, string2, string3);
    }

    public String getparamTts(String string2) {
        if (!soLoadedInThisClassLoader) {
            Log.e((String)TAG, (String)"library is not loaded");
            return "library is not loaded";
        }
        this.CheckTtsHandle();
        NativeNui nativeNui = this;
        return nativeNui.native_tts_get_param(nativeNui.tts_handle, string2);
    }

    public int getUtf8CharsNum(String string2) {
        if (!soLoadedInThisClassLoader) {
            Log.e((String)TAG, (String)"library is not loaded");
            return 0;
        }
        this.CheckTtsHandle();
        NativeNui nativeNui = this;
        return nativeNui.native_get_num_of_chars(nativeNui.tts_handle, string2);
    }

    private void onNuiTtsEventCallback_(int n2, byte[] byArray, int n3) {
        if (this.tts_callback != null) {
            this.tts_callback.onTtsEventCallback(INativeTtsCallback.TtsEvent.fromInt(n2), new String(byArray), n3);
        }
    }

    private void onNuiTtsDataCallback_(byte[] byArray, int n2, byte[] byArray2) {
        if (this.tts_callback != null) {
            this.tts_callback.onTtsDataCallback(new String(byArray), n2, byArray2);
        }
    }

    private void onNuiTtsVolCallback_(int n2) {
        if (this.tts_callback != null) {
            this.tts_callback.onTtsVolCallback(n2);
        }
    }

    static {
        soLoadedInThisClassLoader = false;
        try {
            System.loadLibrary("neonuijni_public");
            soLoadedInThisClassLoader = true;
        }
        catch (Throwable throwable) {
            soLoadedInThisClassLoader = false;
            Log.e((String)TAG, (String)"load library failed, ".concat(String.valueOf(throwable)));
        }
    }
}

