package com.sd.api.ui

import android.os.Bundle
import android.view.KeyEvent
import android.view.View
import androidx.activity.enableEdgeToEdge
import androidx.appcompat.app.AppCompatActivity
import androidx.core.view.isVisible
import com.minedata.minenavi.addons.DistanceBean
import com.minedata.minenavi.addons.SpannableBuilder
import com.minedata.minenavi.mapdal.NativeEnv
import com.minedata.minenavi.mapdal.NdsPoint
import com.minedata.minenavi.navi.GuidanceText
import com.minedata.minenavi.navi.NaviProgressData
import com.minedata.minenavi.navi.RouteExplorer
import com.minedata.minenavi.navi.SmoothNaviData
import com.minedata.minenavi.navi.TmcSections
import com.minedata.minenavi.navi.TurnIconModel
import com.minedata.minenavi.util.MineNaviUtil
import com.minedata.minenavi.util.Tools
import com.msmap.api.R
import com.msmap.api.databinding.ActivityMineNaiDirBinding
import com.sd.api.bean.DriverRouteBean
import com.sd.api.core.MapReadyView
import com.sd.api.core.basic.OnDriveRoute
import com.sd.api.core.basic.mine.MineNai
import com.sd.api.core.basic.mine.MineNaiParams
import com.sd.api.core.basic.mine.MineRoutePlans
import com.sd.api.factorys.MapCoreApi
import com.sd.api.intfaces.OnComCan
import com.sd.api.intfaces.OnNaviPresenterListener
import com.sd.api.ui.MapMultiView.OnMapReadyLis
import com.sd.api.ui.dialog.ExitNaiDialog
import com.sd.api.utils.Utils

/**
 * 直接开始导航
 */
class MineNaiDirActivity : AppCompatActivity(), OnNaviPresenterListener {

    private lateinit var binding: ActivityMineNaiDirBinding

    private var mapReadView: MapReadyView? = null

    private var mineNaiParams: MineNaiParams? = null

    //获取接口功能实例
    private var mapCoreApi = MapCoreApi.mapCoreApi

    //四维导航地图工具
    private lateinit var mUtils: Utils

    private lateinit var dialogFragment: ExitNaiDialog

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        enableEdgeToEdge()
        binding = ActivityMineNaiDirBinding.inflate(layoutInflater)
        setContentView(binding.root)
        /*  ViewCompat.setOnApplyWindowInsetsListener(findViewById(R.id.main)) { v, insets ->
              val systemBars = insets.getInsets(WindowInsetsCompat.Type.systemBars())
              v.setPadding(systemBars.left, systemBars.top, systemBars.right, systemBars.bottom)
              insets
          }*/
        mUtils = Utils()
        mUtils.init(this)
        mineNaiParams = intent.getParcelableExtra<MineNaiParams>("mineNaiParams")

        MineNai.onNaviPresenterListener = this

        binding.mapMultiView.addMapRenderCallback(object : OnMapReadyLis {
            override fun onMapReady(mapReadyView: MapReadyView) {
                this@MineNaiDirActivity.mapReadView = mapReadyView
                //切换为2D平面图
                mapReadyView.mMineMap?.elevation=0f
                //算路成功以后启动导航
                startPlan()
            }
        })
    }

    private fun startPlan() {
        val startPoint = mineNaiParams!!.starPoint
        // 终点坐标116.3793,39.8643
        val endPoint = mineNaiParams!!.endPoint
        // 终点名称
        val endName = mineNaiParams!!.endName
        val startName = mineNaiParams!!.startName

        var ways = mineNaiParams!!.ways

        //开始路径规划
        mapCoreApi.drivingPathPlanning(
            startPoint, startName, endPoint, endName, ways, mapReadView, object : OnDriveRoute {
                override fun onDriverRoute(driverRouteBean: DriverRouteBean) {
                    var routeBase = driverRouteBean.routeBase
                    MineNai.startNaviFormRouteBase(routeBase, startPoint, mapReadView)
                }
            }
        )
    }

//    override fun onDestroy() {
//        super.onDestroy()
//        MineNai.stopNavi()
//    }

    override fun onTracking(ratio: Float) {
        binding.layoutNavi.tmcBarView.updateRatio(ratio)
        binding.layoutNavi.horCarTmc.updateRatio(ratio)
    }


    /**
     * 刷新导航中的自车位置
     */
    fun showNavingCarPosition(ndsPoint: NdsPoint?, heading: Float) {
        synchronized(NativeEnv.SyncObject) {
            if (ndsPoint == null) {
                return
            }
            var mMapCar = MineNai.mMapCar
            mMapCar?.setPositionNds(Tools.ndsPointToLatLng(ndsPoint))
            mMapCar?.setHeading(heading)
            //刷新小地图自车位置
            /*         if (mSmallMapCar != null) {
                         mSmallMapCar!!.orientAngle(heading)
                         mSmallMapCar!!.setPositionNds(Tools.ndsPointToLatLng(ndsPoint))
                     }
                     if (mNaviCompassOverlay != null) {
                         mNaviCompassOverlay!!.setPositionNds(ndsPoint)
                     }*/
        }
    }


    override fun onSmoothTracking(data: SmoothNaviData) {
        val carHeading =
            if (data != null) data.carHeading else MineRoutePlans.mRouteBase!!.getStartDirection()
                .toFloat()
        val mapHeading = if (data != null) data.mapHeading else 0f
        var mineMap = mapReadView?.mMineMap

        showNavingCarPosition(data.carPos, carHeading)
        mineMap?.setHeading(mapHeading)
        mineMap?.setElevation(50.0f)
        mineMap?.setFovy(35f)
        mineMap?.setViewShiftXY(0f, 0.55f)
        mineMap?.setNdsPointToCenter(data.carPos.x, data.carPos.y)
        val zoomLevel = mineMap!!.getAutomaticZoomLevelForMineMap(0.2f)
        if (zoomLevel != -1f) {
            mineMap!!.setZoomLevel(zoomLevel)
        }
    }


    /**
     * 设置剩余行程距离时间
     */
    private fun setResidualDistance(hour: Int, distance: Int) {
        val distanceBean = mUtils.formatDistance(distance, false)
        val timeBean = mUtils.calcTimeBean(hour)

        if (binding.layoutNavi.tvResidualTimeDistance.isVisible) {
            val stringBuilder = StringBuilder()
            stringBuilder.append(distanceBean.distanceValue).append(distanceBean.distanceUnit)
            binding.layoutNavi.tvResidualTimeDistance.setText(stringBuilder.toString())
            stringBuilder.delete(0, stringBuilder.length)
            stringBuilder
//                .append("剩余")
                .append(if (timeBean.hour == 0) "" else "${timeBean.hour}")
                .append(if (timeBean.hour == 0) "" else "小时")
                .append("${timeBean.minute}")
                .append(if (timeBean.hour == 0) "分钟" else "分")
            binding.layoutNavi.tvTime.setText(stringBuilder.toString())
        }
    }

    /**
     * 设置到达时间
     */
    private fun setResidualTime(naviProgressData: NaviProgressData?) {
        if (naviProgressData == null) return
        val s_arriveTime =
            MineNaviUtil.relativeTimeStringFromNow(
                naviProgressData.remainingTime,
                mUtils.is24Hour()
            )

        var stringBuilder = StringBuilder()
        if (s_arriveTime.contains("天")) {
            stringBuilder
//                .append("预计")
                .append(s_arriveTime.substring(0, s_arriveTime.indexOf("天") + 1) + "")
                .append(s_arriveTime.substring(s_arriveTime.indexOf("天") + 1, s_arriveTime.length))
                .append("到")
        } else if (s_arriveTime.contains("日")) {
            stringBuilder
//                .append("预计")
                .append(s_arriveTime.substring(0, s_arriveTime.indexOf("日") + 1) + "")
                .append(s_arriveTime.substring(s_arriveTime.indexOf("日") + 1, s_arriveTime.length))
                .append("到")
        } else {
            stringBuilder
//                .append("预计")
                .append(s_arriveTime)
                .append("到")
        }
        binding.layoutNavi.tvArriveTime.setText(stringBuilder.toString())
    }

    override fun onDataUpdated(naviProgressData: NaviProgressData) {
        /*      mSmallMapViewRouteRect = naviProgressData.remainingBoundingBox
              fitRouteInSmallMap()*/
        var mRouteBase = MineRoutePlans.mRouteBase
        setResidualDistance(
            naviProgressData.remainingTime,
            naviProgressData.routeLength - naviProgressData.curDistance
        )
        setResidualTime(naviProgressData)
        val remainingTrafficLightCount: Int =
            mRouteBase?.calculateTrafficLightCountInDistanceRange(
                naviProgressData.curDistance,
                naviProgressData.routeLength
            ) ?: 0
        val statusByRoute =
            RouteExplorer.getInstance().getStatusByRoute(mRouteBase)

        if (statusByRoute != null && statusByRoute.remainingDistance < 100 * 1000) {
            with(binding.layoutNavi) {
                ivBottomTrafficLight.setVisibility(View.VISIBLE)
                tvTrafficLightNumber.setVisibility(View.VISIBLE)
                tvTrafficLightNumber.setText(remainingTrafficLightCount.toString() + "")
            }
        } else {
            with(binding.layoutNavi) {
                ivBottomTrafficLight.setVisibility(View.GONE)
                tvTrafficLightNumber.setVisibility(View.GONE)
            }
        }
    }

    override fun onTiBarUpdated(tmcSections: TmcSections) {
        binding.layoutNavi.tmcBarView.post {
            if (tmcSections != null) {
                binding.layoutNavi.tmcBarView.setTmcSections(tmcSections)
            }
        }
    }

    override fun onTextChanged(guidanceText: GuidanceText) {
        if (guidanceText?.turnIconModel?.valid ?: false) {
            when (guidanceText?.turnIconModel?.type) {//交叉路口、、环岛
                TurnIconModel.Type.junction, TurnIconModel.Type.rotary -> {
//                        println("----------- 转角和环岛 iconId= ${guidanceText.turnIconModel.iconId}")
//                        println("----------- 转角和环岛 toDirection= ${guidanceText.turnIconModel.toDirection}")
                    binding.layoutNavi.turnIconView.setTurnIconModel(guidanceText.turnIconModel)

                }

                TurnIconModel.Type.iconId -> {// 图片类型
//                        println("-----------  iconId= ${guidanceText.turnIconModel.iconId}")
//                        println("----------- toDirection = ${guidanceText.turnIconModel.toDirection}")
                    binding.layoutNavi.turnIconView.setTurnIconId(guidanceText.turnIconModel.iconId)
                }
            }
        } else {
            binding.layoutNavi.turnIconView.setTurnIconId(
//                    guidanceText?.turnIconModel?.iconId ?: 0
                R.drawable.go_here
            )
        }

        with(binding.layoutNavi) {
            tvTurnAction.setText(guidanceText?.action)
            tvTurnRoadName.setText(mUtils.toDBC(guidanceText?.name))
        }
    }

    override fun onDistanceChanged(distance: Int) {
        val distanceBean: DistanceBean = mUtils.formatDistance(distance, false)
        val distanceToTurnInJunctionViewSpannable = SpannableBuilder.create(this)
            .append(distanceBean.distanceValue, R.dimen.sp_24, R.color.text_black)
            .append(distanceBean.distanceUnit, R.dimen.sp_14, R.color.text_black)
            .build()
        binding.layoutNavi.tvTurnDistance.setText(distanceToTurnInJunctionViewSpannable)
    }

    override fun onArriveDestination() {
    }

    override fun onNaviEnded() {
    }

    override fun dispatchKeyEvent(event: KeyEvent): Boolean {
        if ((event.getKeyCode() == KeyEvent.KEYCODE_BACK) || event.getKeyCode() == KeyEvent.KEYCODE_HOME) {
            dialogFragment = ExitNaiDialog()
            dialogFragment.onComCan = object : OnComCan {
                override fun onComfirm() {
                    MineNai.stopNavi()
                    finish()
                }

                override fun onCancel() {
                }
            }
            dialogFragment.show(supportFragmentManager, "exit")
            return true
        } else {
            return super.dispatchKeyEvent(event)
        }
    }


}