package com.sd.api.maps.mine

import com.minedata.minenavi.map.MineMap
import com.minedata.minenavi.mapdal.CoordType
import com.sd.api.core.MapReadyView

/**
 *四维切换底图图层
 */
internal object MineLayers {

    fun toggleLayers(mapReadView: MapReadyView?, type: Int) {
        when (type) {
            1 -> {
                switch2D(mapReadView?.mMineMap)
            }

            2 -> {
                switchSatelliteLayer(mapReadView?.mMineMap)
            }
        }
    }


    private fun switch2D(mMineMap: MineMap?) {
        //切换为2D平面图
//        mMineMap?.setElevation(90f)
        mMineMap?.setStyleClass("DEFAULT")
        mMineMap?.enableSatelliteLayer(false)
    }

    private fun switchSatelliteLayer(mMineMap: MineMap?) {
        //切换为卫星图
        mMineMap?.setSatelliteImageType(MineMap.SatelliteImageSource.bing, CoordType.GCJ02)
        mMineMap?.setStyleClass("SATELLITE")
        mMineMap?.enableSatelliteLayer(true)
    }

}