package com.sd.api.maps

import com.amap.api.services.core.AMapException
import com.minedata.minenavi.poiquery.GeocodeResult
import com.minedata.minenavi.poiquery.GeocodeSearch
import com.minedata.minenavi.poiquery.LatLonPoint
import com.minedata.minenavi.poiquery.RegeocodeQuery
import com.minedata.minenavi.poiquery.RegeocodeResult
import com.sd.api.MAP_TYPE
import com.sd.api.MSDKInitializer
import com.sd.api.UserCtx
import com.sd.api.bean.RegeocodeRes
import com.amap.api.services.geocoder.GeocodeSearch as AGeocodeSearch
import com.amap.api.services.geocoder.GeocodeResult as AGeocodeResult

/**逆地理编码*/
object MSRegeoCode : GeocodeSearch.OnGeocodeSearchListener, AGeocodeSearch.OnGeocodeSearchListener {

    private var mSOnRegeo: MSOnRegeo? = null

    /**逆地理编码信息回调*/
    interface MSOnRegeo {
        fun onRegeo(regeocodeRes: RegeocodeRes?)
    }

    /**逆地理编码
     * @param lat 维度
     * @param lng 经度
     * @param msOnRegeo 信息回调
     */
    fun geoCoder(
        lat: Double,
        lng: Double,
        msOnRegeo: MSOnRegeo
    ) {
        if (lat == 0.0 || lng == 0.0)
            return
        this.mSOnRegeo = msOnRegeo
        var context= UserCtx.Companion.instance.mContext
        when (MSDKInitializer.getMapType()) {
            MAP_TYPE.MINE -> {
                val geocoderSearch = GeocodeSearch(context)
                geocoderSearch.addOnGeocodeSearchListener(this)
                // 参数表示地理坐标点
                val query = RegeocodeQuery(LatLonPoint(lat, lng))
                geocoderSearch.getFromLocationAsyn(query)
            }

            MAP_TYPE.AMAP -> {
                // 第一个参数表示一个Latlng，第二参数表示范围多少米，第三个参数表示是火系坐标系还是GPS原生坐标系
                val query = com.amap.api.services.geocoder.RegeocodeQuery(
                    com.amap.api.services.core.LatLonPoint(lat, lng), 200f,
                    com.amap.api.services.geocoder.GeocodeSearch.AMAP
                )
                var geocoderSearch = com.amap.api.services.geocoder.GeocodeSearch(context)
                geocoderSearch.setOnGeocodeSearchListener(this)
                geocoderSearch.getFromLocationAsyn(query) // 设置异步逆地理编码请求
            }
        }
    }


    //-------------------------- 四维 回调----------------------------------
    override fun onGeocodeSearched(
        p0: GeocodeResult?,
        p1: Int
    ) {
    }

    override fun onRegeocodeSearched(
        regeocodeResult: RegeocodeResult?,
        resultID: Int
    ) {
        // 解析 regeocodeResult 获取的逆地理编码信息
        if (!regeocodeResult?.regeocodeAddressList.isNullOrEmpty()) {
            var temp = regeocodeResult.regeocodeAddressList.first()
            var regeocodeRes = RegeocodeRes().apply {
                province = temp.province
//                provinceCode = temp.provinceCode
                city = temp.city
                cityCode = temp.cityCode
                district = temp.district
                town = temp.town
//                village = temp.village
            }
            mSOnRegeo?.onRegeo(regeocodeRes)
        } else {
            mSOnRegeo?.onRegeo(null)
        }
    }


    //-------------------------- 高德 回调----------------------------------
    /**
     * 逆地理编码回调
     */
    override fun onRegeocodeSearched(
        result: com.amap.api.services.geocoder.RegeocodeResult?,
        rCode: Int
    ) {
        if (rCode == AMapException.CODE_AMAP_SUCCESS) {
            var temp = result!!.getRegeocodeAddress()
            var regeocodeRes = RegeocodeRes().apply {
                province = temp.province
//                provinceCode = temp.province
                city = temp.city
                cityCode = temp.cityCode
                district = temp.district
                town = temp.township
//                village = temp.village
            }
            mSOnRegeo?.onRegeo(regeocodeRes)
        } else {
            mSOnRegeo?.onRegeo(null)
        }
    }

    override fun onGeocodeSearched(
        p0: AGeocodeResult?,
        p1: Int
    ) {
    }


}