package com.sd.api.maps

import com.sd.api.MAP_TYPE
import com.sd.api.MSDKInitializer
import com.sd.api.core.MapReadyView
import com.sd.api.maps.MSLocStyle
import com.sd.api.maps.amap.AmapLocationStyle
import com.sd.api.maps.mine.MineLocationStyle

/**
 * 显示定位蓝点
 *
 * @constructor Create empty Show my loc style
 */
object LocStyle {

    /**
     * 设置定位蓝点样式
     * @param mapReadView 地图准备就绪视图对象
     * @param type 定位类型，默认为LOCATION_TYPE_LOCATION_ROTATE，表示连续定位并旋转视角
     */
    fun setLocationStyle(
        mapReadView: MapReadyView?,
        type: Int = MSLocStyle.LOCATION_TYPE_LOCATION_ROTATE
    ){
        when (MSDKInitializer.getMapType()) {
            MAP_TYPE.MINE -> {
                MineLocationStyle.setLocationStyle(mapReadView, type)
            }

            MAP_TYPE.AMAP -> {
                AmapLocationStyle.setLocationStyle(mapReadView, type)
            }
        }
    }
}