package com.sd.api.maps

import androidx.core.graphics.toColorInt
import com.sd.api.MAP_TYPE
import com.sd.api.MSDKInitializer
import com.sd.api.core.MapReadyView
import com.sd.api.maps.cdata.MSOverlay
import com.sd.api.core.basic.mine.MineDrawInMap
import com.sd.api.maps.amap.AmapDrawInMap
import com.sd.api.maps.cdata.MSLatLng
import com.sd.api.maps.cdata.MSMarker

/**
 * 绘制点、线、面
 *
 * @constructor Create empty Marker pro
 */
object DrawInMap {

    /**
     * 绘制 marker 点
     * @param mapReadView 地图准备就绪的视图对象
     * @param lat 纬度坐标
     * @param lng 经度坐标
     * @return MSMarker 标记点对象
     */
    fun drawMarket(
        mapReadView: MapReadyView?,
        lat: Double,
        lng: Double
    ): MSMarker {
        when (MSDKInitializer.getMapType()) {
            MAP_TYPE.MINE -> {
                return MineDrawInMap.drawMarket(mapReadView, lat, lng)
            }

            MAP_TYPE.AMAP -> {
                return AmapDrawInMap.drawMarket(mapReadView, lat, lng)
            }
        }
    }

    /**
     * 绘制线
     * @param mapReadView 地图加载返回
     * @param msLatLng 坐标点集合
     * @param fcolor 线颜色
     * @param outlineColor 描边颜色
     * @param width 线宽度，默认为10f
     * @param isDotted 是否为虚线，默认为false
     * @return MSOverlay 覆盖物对象
     */
    fun drawPolyline(
        mapReadView: MapReadyView?,
        msLatLng: List<MSLatLng>,
        fcolor: Int = "#000000".toColorInt(),
        outlineColor: Int="#00000000".toColorInt(),
        width: Float = 10f,
        isDotted: Boolean = false
    ): MSOverlay {
        when (MSDKInitializer.getMapType()) {
            MAP_TYPE.MINE -> {
                return MineDrawInMap.drawPolyline(mapReadView, msLatLng, fcolor,outlineColor, width, isDotted)
            }

            MAP_TYPE.AMAP -> {
                return AmapDrawInMap.drawPolyline(mapReadView, msLatLng, fcolor, width, isDotted)
            }
        }
    }


    /**绘制圆形
     * @param mapReadView 地图准备就绪视图对象
     * @param lat 维度
     * @param lng 经度
     * @param radius 半径（米）
     * @param fillColor 填充颜色，默认为半透明红色
     * @param strokeColor 边框颜色，默认为半透明蓝色
     * @param strokeWidth 边框宽度，默认为15f
     * @return MSOverlay 返回覆盖物对象
     */
    fun drawCircle(
        mapReadView: MapReadyView?,
        lat: Double,
        lng: Double,
        radius: Float,
        fillColor: Int = "#50FF0000".toColorInt(),
        strokeColor: Int = "#00000000".toColorInt(),
        strokeWidth: Float = 15f
    ): MSOverlay{
        when (MSDKInitializer.getMapType()) {
            MAP_TYPE.MINE -> {
                return MineDrawInMap.drawCircle(mapReadView, lat, lng, radius, fillColor, strokeColor, strokeWidth)
            }

            MAP_TYPE.AMAP -> {
                return AmapDrawInMap.drawCircle(mapReadView, lat, lng, radius, fillColor, strokeColor, strokeWidth)
            }
        }
    }

    /***
     * 绘制多边形
     * @param msLatLng   添加多边形顶点坐标集合
     * @param dLine 是否虚线
     * @param fillColor 填充颜色
     * @param strokeWidth 边框宽度
     * @param strokeColor 边框颜色
     * ****/
    fun drawPolygon(
        mapReadView: MapReadyView?,
        msLatLng: List<MSLatLng>,
        dLine: Boolean = false,
        fillColor: Int = "#10FF00FF".toColorInt(),
        strokeWidth: Float = 5f,
        strokeColor: Int = "#50FF00FF".toColorInt()
    ): MSOverlay{
        when (MSDKInitializer.getMapType()) {
            MAP_TYPE.MINE -> {
                return MineDrawInMap.drawPolygon(mapReadView, msLatLng, dLine, fillColor, strokeWidth, strokeColor)
            }

            MAP_TYPE.AMAP -> {
                return AmapDrawInMap.drawPolygon(mapReadView, msLatLng, dLine, fillColor, strokeWidth, strokeColor)
            }
        }
    }

}