package com.sd.api.maps

import com.sd.api.MAP_TYPE
import com.sd.api.MSDKInitializer
import com.sd.api.core.MapReadyView
import com.sd.api.maps.cdata.MSOverlay
import com.sd.api.maps.cdata.MSMarker

/**
 * 删除地图上的绘制
 */
object DelDrawInMap {


    /**
     * 绘制 marker 点
     * @param mapReadView 地图准备就绪的视图对象
     * @param lat 纬度坐标
     * @param lng 经度坐标
     * @return MSMarker 标记点对象
     */
    /*fun drawMarket(
        mapReadView: MapReadyView?,
        lat: Double,
        lng: Double
    ): MSMarker {
        var context = UserCtx.instance.mContext

        // 根据不同的地图类型绘制标记点
        when (MSDKInitializer.getMapType()) {
            // 处理自定义地图类型的标记点绘制
            MAP_TYPE.MINE -> {
                val icon = BitmapFactory.decodeResource(context?.resources, R.drawable.market_loc)
                val latLng = LatLng(lat, lng)
                var options = MarkerOptions()
                    .zLevel(7)
                    .bitmap(icon)
                    // 位置坐标
                    .position(latLng)
                var maker = mapReadView?.mMineMap?.addMarker(options)
                MSMarker.maker = maker
                return MSMarker
            }

            // 处理高德地图类型的标记点绘制
            MAP_TYPE.AMAP -> {
                val aLatLng = ALatLng(lat, lng)
                val aMarkerOption = AMarkerOptions().apply {
                    position(aLatLng)
                    icon(
                        BitmapDescriptorFactory.fromBitmap(
                            BitmapFactory
                                .decodeResource(context?.resources, R.drawable.market_loc)
                        )
                    )
                }
                var aMaker = mapReadView?.aMap?.addMarker(aMarkerOption)
                MSMarker.amaker = aMaker
                return MSMarker
            }
        }
    }*/


    /**
     * 绘制线
     * @param mapReadView 地图加载返回
     * @param msLatLng 坐标点集合
     * @param width 线宽度，默认为10f
     * @param fcolor 线颜色，默认为"#FF00FF"对应的int值
     * @param isDotted 是否为虚线，默认为false
     * @return MSOverlay 覆盖物对象
     */
  /*  fun drawPolyline(
        mapReadView: MapReadyView?,
        msLatLng: List<MSLatLng>,
        width: Float = 10f,
        fcolor: Int = "#FF00FF".toColorInt(),
        isDotted: Boolean = false
    ): MSOverlay {
        // 根据地图类型绘制不同平台的线
        when (MSDKInitializer.getMapType()) {
            // 绘制自定义地图的线
            MAP_TYPE.MINE -> {
                var latLngs = msLatLng.map {
                    LatLng(it.lat, it.lng)
                }
                var options = PolylineOptions()
                    // 添加顶点坐标
                    .addAll(latLngs)
                    .width(width)
                    .color(fcolor)
                    .setDottedLine(isDotted)
                var polyline = mapReadView?.mMineMap?.addPolyline(options)
                MSOverlay.polyline = polyline
                return MSOverlay
            }

            // 绘制高德地图的线
            MAP_TYPE.AMAP -> {
                var latLngs = msLatLng.map {
                    ALatLng(it.lat, it.lng)
                }
                val aOption = APolylineOptions().addAll(latLngs)
                    .width(width)
                    .color(fcolor)
                    .setDottedLine(isDotted)
                var polyline = mapReadView?.aMap?.addPolyline(aOption)
                MSOverlay.aPolyline = polyline
                return MSOverlay
            }
        }
    }*/


    /**绘制圆形
     * @param mapReadView 地图准备就绪视图对象
     * @param lat 维度
     * @param lng 经度
     * @param radius 半径（米）
     * @param fillColor 填充颜色，默认为半透明红色
     * @param strokeColor 边框颜色，默认为半透明蓝色
     * @param strokeWidth 边框宽度，默认为15f
     * @return MSOverlay 返回覆盖物对象
     */
  /*  fun drawCircle(
        mapReadView: MapReadyView?,
        lat: Double,
        lng: Double,
        radius: Float,
        fillColor: Int = "#50FF0000".toColorInt(),
        strokeColor: Int = "#500000FF".toColorInt(),
        strokeWidth: Float = 15f
    ): MSOverlay {
        // 根据地图类型绘制不同类型的圆形
        when (MSDKInitializer.getMapType()) {
            MAP_TYPE.MINE -> {
                var latLng = LatLng(lat, lng)
                val options = CircleOptions()
                    .center(latLng)
                    .radius(radius)
                    .fillColor(fillColor)
                    .strokeColor(strokeColor)
                    .strokeWidth(strokeWidth)
                var circle = mapReadView?.mMineMap?.addCircle(options)
                MSOverlay.circle = circle
                return MSOverlay
            }

            MAP_TYPE.AMAP -> {
                var latLng = ALatLng(lat, lng)
                val options = ACircleOptions()
                    .center(latLng)
                    .radius(radius.toDouble())
                    .fillColor(fillColor)
                    .strokeColor(strokeColor)
                    .strokeWidth(strokeWidth)
                var circle = mapReadView?.aMap?.addCircle(options)
                MSOverlay.aCircle = circle
                return MSOverlay
            }
        }
    }*/


    /***
     * 绘制多边形
     * @param msLatLng   添加多边形顶点坐标集合
     * @param dLine 是否虚线
     * @param fillColor 填充颜色
     * @param strokeWidth 边框宽度
     * @param strokeColor 边框颜色
     * ****/
 /*   fun drawPolygon(
        mapReadView: MapReadyView?,
        msLatLng: List<MSLatLng>,
        dLine: Boolean = false,
        fillColor: Int = "#10FF00FF".toColorInt(),
        strokeWidth: Float = 5f,
        strokeColor: Int = "#50FF00FF".toColorInt()
    ): MSOverlay {
        when (MSDKInitializer.getMapType()) {
            MAP_TYPE.MINE -> {
                var latLngs = msLatLng.map {
                    LatLng(it.lat, it.lng)
                }
                // 声明 多边形参数对象
                val polygonOptions = PolygonOptions().apply {
                    addAll(latLngs)
                    fillColor(fillColor)
                    strokeWidth(strokeWidth)
                    strokeColor(strokeColor)
                    dottedLine(dLine)
                }
                var polygon = mapReadView?.mMineMap?.addPolygon(polygonOptions)
                MSOverlay.polygon = polygon
                return MSOverlay
            }

            MAP_TYPE.AMAP -> {
                var latLngs = msLatLng.map {
                    ALatLng(it.lat, it.lng)
                }
                val aPolygonOptions = APolygonOptions().apply {
                    addAll(latLngs)
                    fillColor(fillColor)
                    strokeWidth(strokeWidth)
                    strokeColor(strokeColor)
                }
                var polygon = mapReadView?.aMap?.addPolygon(aPolygonOptions)
                MSOverlay.aPolygon = polygon
                return MSOverlay
            }
        }
    }*/


    /**
     * 删除地图上的标记点
     * @param mapReadView 地图准备就绪的视图对象，可能为null
     * @param mSMarker 要删除的标记点对象，可能为null
     */
    fun deleteMarker(mapReadView: MapReadyView?, mSMarker: MSMarker?) {
        if (mSMarker == null)
            return

        // 根据不同的地图类型执行相应的删除操作
        when (MSDKInitializer.getMapType()) {
            MAP_TYPE.MINE -> {
                // 从自定义地图中移除指定的标记点
                mapReadView?.mMineMap?.removeMarker(mSMarker.maker)
            }

            MAP_TYPE.AMAP -> {
                //移除指定的标记点
                MSMarker.amaker?.remove()
                // 清空高德地图上所有已经标注的marker
//            mapReadView?.aMap?.clear()
            }
        }
    }


    /**
     * 删除地图上的线
     * @param mapReadView 地图准备就绪的视图对象，可能为null
     * @param mSOverlay 包含折线信息的覆盖物对象，可能为null
     */
    fun deletePolyline(mapReadView: MapReadyView?, mSOverlay: MSOverlay?) {
        if (mSOverlay == null)
            return
        // 根据不同的地图类型删除对应的折线
        when (MSDKInitializer.getMapType()) {
            MAP_TYPE.MINE -> {
                mapReadView?.mMineMap?.removeOverlay(mSOverlay.polyline)
            }

            MAP_TYPE.AMAP -> {
                mSOverlay.aPolyline?.remove()
            }
        }
    }


    /**
     * 删除圆形覆盖物
     * @param mapReadView 地图准备视图对象，可能为null
     * @param mSOverlay 圆形覆盖物对象，可能为null
     */
    fun deleteCircle(mapReadView: MapReadyView?, mSOverlay: MSOverlay?) {
        if (mSOverlay == null) {
            return
        }
        // 根据不同的地图类型执行对应的圆形删除操作
        when (MSDKInitializer.getMapType()) {
            MAP_TYPE.MINE -> {
                mapReadView?.mMineMap?.removeOverlay(mSOverlay.circle)
            }

            MAP_TYPE.AMAP -> {
                mSOverlay.aCircle?.remove()
            }
        }
    }

    /**
     * 删除地图上的面
     * @param mapReadView 地图准备就绪的视图对象，可能为null
     * @param mSOverlay 面覆盖物对象，可能为null
     */
    fun deletePolygon(mapReadView: MapReadyView?, mSOverlay: MSOverlay?) {
        if (mSOverlay == null) {
            return
        }
        // 根据不同的地图类型执行对应的删除操作
        when (MSDKInitializer.getMapType()) {
            MAP_TYPE.MINE -> {
                mapReadView?.mMineMap?.removeOverlay(mSOverlay.polygon)
            }

            MAP_TYPE.AMAP -> {
                mSOverlay.aPolygon?.remove()
            }
        }
    }


    //    /****改变地图显示区域**/
//    fun setMapZoom(mapReadView: MapReadyView?, zoom: Float=16f) {
//        when (MSDKInitializer.getMapType()) {
//            MAP_TYPE.MINE -> {
//                mapReadView?.mMineMap?.setZoomLevel(zoom)
//            }
//
//            MAP_TYPE.AMAP -> {
//                var mCameraUpdate = CameraUpdateFactory.zoomTo(zoom)
//                mapReadView?.aMap?.moveCamera(mCameraUpdate)
//            }
//        }
//    }
}