package com.sd.api.factorys

import com.sd.api.maps.cdata.MSLatLng
import com.sd.api.bean.WayPoi
import com.sd.api.core.MapReadyView
import com.sd.api.maps.cdata.MSMarker
import com.sd.api.maps.cdata.MSOverlay
import com.sd.api.core.basic.OnDriveRoute
import com.sd.api.maps.inters.OnMSPoiSearchLis
import com.sd.api.core.basic.OnMsGpsLoc
import com.sd.api.core.basic.mine.MimeGestures
import com.sd.api.core.basic.mine.MineDrawInMap
import com.sd.api.core.basic.mine.MineGpsLocation
import com.sd.api.maps.mine.MineLocationStyle
import com.sd.api.maps.mine.MineMethodAdv
import com.sd.api.core.basic.mine.MineNai
import com.sd.api.maps.mine.MinePoiSearch
import com.sd.api.core.basic.mine.MineRoutePlans
import com.sd.api.core.basic.mine.MineToggleLayers
import com.sd.api.intfaces.OnNaviPresenterListener

/**
 * 四维基础地图实现
 */
class MineBasic : IMapBasic {
    override fun toggleLayers(mapReadView: MapReadyView?, type: Int) {
        MineToggleLayers.toggleLayers(mapReadView, type)
    }

    override fun setLocationStyle(
        mapReadView: MapReadyView?,
        type: Int
    ) {
        MineLocationStyle.setLocationStyle(mapReadView, type)
    }

    override fun setRotateGesturesEnabled(
        mapReadView: MapReadyView?,
        enable: Boolean
    ) {
        MimeGestures.setRotateGesturesEnabled(mapReadView, enable)
    }

    override fun setTiltGesturesEnabled(
        mapReadView: MapReadyView?,
        enable: Boolean
    ) {
        MimeGestures.setTiltGesturesEnabled(mapReadView, enable)
    }

    override fun setMapCenter(
        mapReadView: MapReadyView?,
        lat: Double,
        lng: Double
    ) {
        MineMethodAdv.setMapCenter(mapReadView, lat, lng)
    }

    override fun setMapZoom(mapReadView: MapReadyView?, zoom: Float) {
        MineMethodAdv.setMapZoom(mapReadView, zoom)
    }

    override fun drawMarket(
        mapReadView: MapReadyView?,
        lat: Double,
        lng: Double
    ): MSMarker {
        return MineDrawInMap.drawMarket(mapReadView, lat, lng)
    }

    override fun drawPolyline(
        mapReadView: MapReadyView?,
        msLatLng: List<MSLatLng>,
        fcolor: Int,
        width: Float,
        isDotted: Boolean
    ): MSOverlay {
        return MineDrawInMap.drawPolyline(mapReadView, msLatLng, fcolor, 0,width, isDotted)
    }

    override fun drawCircle(
        mapReadView: MapReadyView?,
        lat: Double,
        lng: Double,
        radius: Float,
        fillColor: Int,
        strokeColor: Int,
        strokeWidth: Float
    ): MSOverlay {
        return MineDrawInMap.drawCircle(
            mapReadView,
            lat,
            lng,
            radius,
            fillColor,
            strokeColor,
            strokeWidth
        )
    }

    override fun drawPolygon(
        mapReadView: MapReadyView?,
        msLatLng: List<MSLatLng>,
        dLine: Boolean,
        fillColor: Int,
        strokeWidth: Float,
        strokeColor: Int
    ): MSOverlay {
        return MineDrawInMap.drawPolygon(
            mapReadView,
            msLatLng,
            dLine,
            fillColor,
            strokeWidth,
            strokeColor
        )
    }

    override fun startPoiSearch(
        keyWord: String,
        lat: Double,
        lng: Double,
        onMSPoiSearchLis: OnMSPoiSearchLis
    ) {
        MinePoiSearch.startPoiSearch(keyWord, lat, lng, onMSPoiSearchLis)
    }

    override fun startPoiSearchBound(
        keyWord: String,
        lat: Double,
        lng: Double,
        radios: Int,
        onMSPoiSearchLis: OnMSPoiSearchLis
    ) {
        MinePoiSearch.startPoiSearchBound(keyWord, lat, lng, radios, onMSPoiSearchLis)
    }


    override fun startLoc(onMsGpsLoc: OnMsGpsLoc) {
        MineGpsLocation.starLoc(onMsGpsLoc)
    }

    override fun stopLoc() {
        MineGpsLocation.stopLoc()
    }

    override fun cleansLoc() {
        MineGpsLocation.cleansLoc()
    }


    override fun drivingPathPlanning(
        starPoint: MSLatLng,
        startName: String,
        endPoint: MSLatLng,
        endName: String,
        ways: List<WayPoi>,
        mapReadView: MapReadyView?,
        onDriveRoute: OnDriveRoute?
    ) {
        MineRoutePlans.drivingPathPlanning(
            starPoint,
            startName,
            endPoint,
            endName,
            ways,
            mapReadView,
            onDriveRoute
        )
    }

    override fun startNavi(
        mapReadView: MapReadyView?,
        navType: Int,
        starPoint: MSLatLng,
        startName: String,
        endPoint: MSLatLng,
        endName: String,
        ways: List<WayPoi>,
        onNaviPresenterListener: OnNaviPresenterListener?
    ) {
        if (navType == 1) {//用户自己实现接口
            MineNai.startNavi(mapReadView, onNaviPresenterListener)
        } else if (navType == 2) {//直接到写好的页面
            MineNai.startNaviDirect(starPoint, startName, endPoint, endName, ways)
        }
    }


    companion object {
        val mineBasic: MineBasic by lazy { MineBasic() }
    }
}