package com.sd.api.core.basic.mine

import android.content.Intent
import android.graphics.Point
import com.minedata.minenavi.map.MineMap
import com.minedata.minenavi.map.Model
import com.minedata.minenavi.map.ModelOptions
import com.minedata.minenavi.map.Overlay
import com.minedata.minenavi.mapdal.DataPreference
import com.minedata.minenavi.mapdal.LatLng
import com.minedata.minenavi.navi.GuidanceText
import com.minedata.minenavi.navi.NaviProgressData
import com.minedata.minenavi.navi.NaviSession
import com.minedata.minenavi.navi.NaviSessionData
import com.minedata.minenavi.navi.NaviSessionParams
import com.minedata.minenavi.navi.RouteBase
import com.minedata.minenavi.navi.RouteExplorer
import com.minedata.minenavi.navi.SmoothNaviData
import com.minedata.minenavi.navi.TmcSections
import com.minedata.minenavi.util.Tools
import com.sd.api.UserCtx
import com.sd.api.maps.cdata.MSLatLng
import com.sd.api.bean.WayPoi
import com.sd.api.core.MapReadyView
import com.sd.api.intfaces.MyMineNaviListener
import com.sd.api.intfaces.OnNaviPresenterListener
import com.sd.api.ui.MineNaiDirActivity

/**
 * 四维导航
 */
object MineNai {

    //初始化四维导航对象
    private var mNaviSession: NaviSession? = null

    // 导航小车
    var mMapCar: Model? = null
    private var mMineMap: MineMap? = null

    /**四维导航监听回调***/
    var onNaviPresenterListener: OnNaviPresenterListener? = null

    init {
        mNaviSession = NaviSession.getInstance()
        mNaviSession?.enableSound(true)
        var naviSessionParams = NaviSessionParams().apply {
            autoReroute = true
            autoRemoveRoute = true
//            useMineNaviGPS = true
        }
        var context = UserCtx.instance.mContext
        mNaviSession!!.init(context, naviSessionParams)
        mNaviSession?.setDataPreference(DataPreference.preferOnline)

    }

    /**
     * 开启四维导航 客户端自实现数据回调
     */
    fun startNavi(mapReadView: MapReadyView?,onNaviPresenterListener:OnNaviPresenterListener?) {
        mNaviSession?.addMineNaviListener(myMineNaviListener)
        var mRouteBas = MineRoutePlans.mRouteBase
        if (mRouteBas != null) {
            mMineMap = mapReadView?.mMineMap
//            drawNavingCar(MineRoutePlans.mStartPoint)
            mNaviSession?.takeRoute(mRouteBas)
        }
    }

    /**
     * 直接跳转页面开启导航
     */
    fun startNaviDirect(
        starPoint: MSLatLng,
        startName: String = "当前位置",
        endPoint: MSLatLng,
        endName: String = "",
        ways: List<WayPoi>
    ) {
        var params = MineNaiParams(starPoint, startName, endPoint, endName, ways)
        var context = UserCtx.instance.mContext

        var inten = Intent(context, MineNaiDirActivity::class.java)
        inten.putExtra("mineNaiParams", params)
        context?.startActivity(inten)
    }

    //是否正在导航
    private var mIsInNavigation = false

    /**
     * 直接使用RouteBase开启导航
     */
    fun startNaviFormRouteBase(routeBase: RouteBase?, mStartPoint: MSLatLng,mapReadView: MapReadyView?) {
//            mMineMap = mapReadView?.mMineMap
        if (routeBase == null)
            return
        mMineMap = mapReadView?.mMineMap
        mNaviSession?.addMineNaviListener(myMineNaviListener)
        val starPoint = Tools.latLngToPoint(LatLng(mStartPoint.lat, mStartPoint.lng))
        drawNavingCar(starPoint)
        mIsInNavigation = true
        mNaviSession?.takeRoute(routeBase)
    }

    fun stopNavi() {
        mIsInNavigation = false
        mNaviSession?.removeRoute()
    }


    /**
     * 添加导航小车
     */
    fun drawNavingCar(point: Point) {
        if (mMineMap == null) {
            return
        }
        if (mMapCar == null) {
            val modelOptions = ModelOptions() // 模型文件相对路径
                .objFile("res/3d_car.obj") // 位置
                .position(Tools.pointToLatLng(point)) // 图层布局类型
                .layer(Overlay.Layer.aboveMarker) // 方向角
                .heading(0f) // 保持尺寸的比例尺
                .keepScaleSize(8.0f) // 缩放因子
                .scaleFactor(0.15f) // 可见性
                .visible(true)
            mMapCar = mMineMap?.addModel(modelOptions)
        }
    }

    /**
     * 移除导航小车
     */
    fun deleteNavingCar() {
        if (mMineMap != null && mMapCar != null) {
            mMineMap?.removeOverlay(mMapCar)
            mMapCar!!.release()
            mMapCar = null
        }
    }


    //-------------- 四维 导航监听 --------------------------
    /**
     * 四维 导航监听
     */
    private var myMineNaviListener = object : MyMineNaviListener() {
        override fun onRerouteStarted() {
            super.onRerouteStarted()
            RouteExplorer.getInstance().removeRoutes()
        }

        override fun onRerouteComplete(data: RouteBase?) {
            super.onRerouteComplete(data)
            MineRoutePlans.mRouteBase = data
            MineRoutePlans.drawPlanPath(MineRoutePlans.mRouteBase)
//            driverRouteBean.routeBase=mRouteBase
        }

        override fun onTracking(data: NaviSessionData) {
//            super.onTracking(data)
            onNaviPresenterListener?.onTracking(data.travelledDistance.toFloat() / data.routeLength)
        }

        override fun onSmoothTracking(data: SmoothNaviData) {
//            super.onSmoothTracking(data)
            onNaviPresenterListener?.onSmoothTracking(data)
        }

        override fun onDataUpdated(naviProgressData: NaviProgressData) {
//            super.onDataUpdated(naviProgressData)
            onNaviPresenterListener?.onDataUpdated(naviProgressData)
        }

        override fun onTiBarUpdated(tmcSections: TmcSections) {
//            super.onTiBarUpdated(tmcSections)
            onNaviPresenterListener?.onTiBarUpdated(tmcSections)
        }

        override fun onTextChanged(guidanceText: GuidanceText) {
//            super.onTextChanged(guidanceText)
            onNaviPresenterListener?.onTextChanged(guidanceText)
        }

        override fun onDistanceChanged(distance: Int) {
//            super.onDistanceChanged(distance)
            onNaviPresenterListener?.onDistanceChanged(distance)
        }

        override fun onArriveDestination() {
//            super.onArriveDestination()
            onNaviPresenterListener?.onArriveDestination()
        }

        override fun onNaviEnded() {
//            super.onNaviEnded()
            onNaviPresenterListener?.onNaviEnded()
        }

    }

}