package com.sd.api.core.basic.amap

import com.amap.api.maps.CameraUpdateFactory
import com.amap.api.maps.model.Poi
import com.amap.api.navi.AMapNavi
import com.amap.api.navi.model.AMapCalcRouteResult
import com.amap.api.navi.model.AMapNaviPath
import com.amap.api.navi.model.NaviLatLng
import com.amap.api.navi.view.RouteOverLay
import com.sd.api.UserCtx
import com.sd.api.bean.DriverRouteBean
import com.sd.api.maps.cdata.MSLatLng
import com.sd.api.bean.WayPoi
import com.sd.api.core.MapReadyView
import com.sd.api.core.basic.OnDriveRoute
import com.sd.api.intfaces.MyAMapNaviListener
import com.amap.api.maps.model.LatLng as ALatLng


/**路劲规划**/
class AmapRoutePlans {

    companion object {
        val instance: AmapRoutePlans by lazy { AmapRoutePlans() }
    }

    //驾车算路回调对象
    private var driverRouteBean = DriverRouteBean.instance

    //驾车路径规划回调接口
    private var onDriveRoute: OnDriveRoute? = null

    //初始化高德 导航 对象
    private var mAMapNavi: AMapNavi? = null

    //高德保存当前算好的路线
    private var routeOverlay: RouteOverLay? = null

    private var mapReadView: MapReadyView? = null


    /**驾车路径规划
     * @param starPoint 起点坐标
     * @param startName 起点名称
     * @param endPoint 终点坐标
     * @param endName 终点名称（高德可不传）
     * @param ways     途经点集合
     * @param mapReadView 地图对象
     */
    fun drivingPathPlanning(
        starPoint: MSLatLng,
        startName: String = "当前位置",
        endPoint: MSLatLng,
        endName: String = "",
        ways: List<WayPoi>,
        mapReadView: MapReadyView?,
        onDriveRoute: OnDriveRoute?
    ) {
        this.onDriveRoute = onDriveRoute
        this.mapReadView = mapReadView

        var context = UserCtx.instance.mContext
        mAMapNavi = AMapNavi.getInstance(context)
        mAMapNavi!!.addAMapNaviListener(aMapNaviListener)

        //这是导航，直接到高德内置组件
        //途经点
        var poiList = mutableListOf<Poi>()
        if (ways.count() > 0) {
            ways.forEach { wpoi ->
                poiList.add(
                    Poi(
                        wpoi.passName,
                        ALatLng(wpoi.passPoint!!.lat, wpoi.passPoint!!.lng),
                        ""
                    )
                )
            }
        }

        //这是路径规划
        var startLatlng = NaviLatLng(starPoint.lat, starPoint.lng)
        var startList = listOf<NaviLatLng>(startLatlng)

        var endLatlng = NaviLatLng(endPoint.lat, endPoint.lng)
        var endList = listOf<NaviLatLng>(endLatlng)
        //途经点
        var wayPoints = mutableListOf<NaviLatLng>()
        if (ways.count() > 0) {
            ways.forEach { wpoi ->
                wayPoints.add(NaviLatLng(wpoi.passPoint!!.lat, wpoi.passPoint!!.lng))
            }
        }
        var strategy = mAMapNavi?.strategyConvert(true, false, false, false, false) ?: 0;

        mAMapNavi?.calculateDriveRoute(
            startList,
            endList,
            wayPoints,
            strategy
//            PathPlanningStrategy.DRIVING_MULTIPLE_ROUTES_DEFAULT
        )
    }


    /**
     * 绘制规划的路线路径。
     * @param mapReadView 地图视图容器，用于获取当前地图实例。
     * @param driverRB 包含路线信息的数据对象。
     */
    private fun drawPlanPath(
        aMapCalcRouteResult: AMapCalcRouteResult?
    ) {
        if (aMapCalcRouteResult == null)
            return
        var context = UserCtx.instance.mContext
        // 清除之前的路线覆盖物
        if (routeOverlay != null) {
            routeOverlay?.removeFromMap()
            routeOverlay = null
        }
        // 从导航结果中获取路径信息并在高德地图上绘制
        val routeIds = aMapCalcRouteResult!!.getRouteid()
        val paths: HashMap<Int, AMapNaviPath> = mAMapNavi!!.getNaviPaths()
        val path: AMapNaviPath? = paths.get(routeIds[0])
        if (path != null) {
            mapReadView?.aMap?.moveCamera(CameraUpdateFactory.changeTilt(0f))
            routeOverlay = RouteOverLay(mapReadView?.aMap, path, context)
            routeOverlay?.setTrafficLine(false)
            routeOverlay?.addToMap()
        }
    }


//    private fun drawRoutes(
//        routeId: Int,
//        path: AMapNaviPath,
//        mapReadView: MapReadyView?,
//        context: Context
//    ) {
//        mapReadView?.aMap?.moveCamera(CameraUpdateFactory.changeTilt(0f))
//         routeOverLay = RouteOverLay(mapReadView?.aMap, path, context)
//        routeOverLay.setTrafficLine(false)
//        routeOverLay.addToMap()
////        routeOverlays.put(routeId, routeOverLay)
//    }


    //-------------- 高德 导航监听 --------------------------
    private var aMapNaviListener = object : MyAMapNaviListener() {

        override fun onCalculateRouteSuccess(aMapCalcRouteResult: AMapCalcRouteResult?) {
            // 路线规划成功
            println("----------onCalculateRouteSuccess")
            drawPlanPath(aMapCalcRouteResult)

            driverRouteBean.aMapCalcRouteResult = aMapCalcRouteResult
            onDriveRoute?.onDriverRoute(driverRouteBean)
//            mAMapNavi?.startNavi(NaviType.EMULATOR);
        }

        override fun onCalculateRouteFailure(result: AMapCalcRouteResult?) {

        }

    }


}