package com.sd.api.core

import android.content.Context
import android.util.Log
import com.minedata.minenavi.map.Model
import com.minedata.minenavi.map.ModelOptions
import com.minedata.minenavi.map.Overlay
import com.minedata.minenavi.mapdal.LatLng
import com.sd.api.MAP_TYPE
import com.sd.api.MSDKInitializer
import com.sd.api.maps.cdata.MSLatLng
import com.sd.api.utils.SmoothMoveUtils
import com.sd.api.utils.FileIoUtils
import kotlinx.coroutines.CoroutineScope
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.launch
import kotlinx.coroutines.withContext
import java.io.File
import java.io.IOException

/***在线地图上绘制小车**/
 object MShowMainCarModel {

    //四维主车obj模型
    private var objPath = ""

    //四维在线地图用户当前位置模型
    private var mainCarMo: Model? = null

    /****加载主车特斯拉模型***/
    private suspend fun loadMainCar(context: Context) {
        withContext(Dispatchers.IO) {
            try {
                var parentFileDir = File(context.filesDir, "models/car_model")
                if (!parentFileDir.exists())
                    parentFileDir.mkdirs()

                objPath =
                    FileIoUtils.assetFilePath(context, "models/car_model/gszh_xyz.obj")
                Log.d("-----", "✅ OBJ文件复制成功: " + objPath)
                var path =
                    FileIoUtils.assetFilePath(context, "models/car_model/Binary_0.jpeg")
                Log.d("-----", "✅ 纹理文件复制成功: " + path)
                path =
                    FileIoUtils.assetFilePath(context, "models/car_model/gszh_xyz.mtl")
                Log.d("-----", "✅ 材质文件复制成功: " + path)
            } catch (e: IOException) {
                e.printStackTrace()
            }
        }
    }


    /****添加我的定位小车模型
     * 这小车模型航向角0是冲下的
     * ***/
    fun addMyLocCarModel(
        mapReadView: MapReadyView?,
        context: Context,
        lat: Double,
        lng: Double,
        heading: Float
    ) {
//        mMineMap?.removeOverlay(mainCarMo)
//        deleteMyLocMarker()
        when (MSDKInitializer.getMapType()) {
            MAP_TYPE.MINE -> {
                CoroutineScope(Dispatchers.IO).launch {
                    loadMainCar(context)

                    if (objPath.isEmpty() || lat == 0.0)
                        return@launch
                    // 模型文件相对路径
                    var modelOptions = ModelOptions()
                        .objFile(objPath)
                        .position(LatLng(lat, lng))
                        .layer(Overlay.Layer.aboveMarker)
                        .heading(heading)
                        .keepScaleSize(8f) // 保持尺寸的比例尺
                        .scaleFactor(0.01f) // 缩放因子
                        .visible(true)
                    if (mainCarMo != null) {
                        mapReadView?.mMineMap?.removeOverlay(mainCarMo)
                    }
                    mainCarMo = mapReadView?.mMineMap?.addModel(modelOptions)
                }
            }

            MAP_TYPE.AMAP -> {

            }
        }
    }


    /**更新模型位置
     * @param lat 纬度
     * @param lng 经度
     * @param heading 航向角
     * **/
    fun upMyLocCarModel(
        lat: Double,
        lng: Double,
        heading: Float
    ) {
        when (MSDKInitializer.getMapType()) {
            MAP_TYPE.MINE -> {
                if (mainCarMo == null)
                    return
                var temp = 0f - 180f - heading

                mainCarMo?.setPosition(LatLng(lat, lng))
                mainCarMo?.setHeading(temp)
            }

            MAP_TYPE.AMAP -> {

            }
        }
    }


    /**平滑更新模型
     * @param from 开始经纬度
     * @param to   结束经纬度
     * @param durationMillis 动画时长默认1000L
     * **/
    fun upMyLocCarModelSmooth(
        from: MSLatLng,
        to: MSLatLng,
        durationMillis: Long=1000L
    ) {
        when (MSDKInitializer.getMapType()) {
            MAP_TYPE.MINE -> {
                SmoothMoveUtils.startSmoothMove(
                    LatLng(from.lat, from.lng),
                    LatLng(from.lat, from.lng),
                    durationMillis,
                    sCarSmooth
                )
            }

            MAP_TYPE.AMAP -> {

            }
        }
    }



    //在线地图主车平滑移动
    private var sCarSmooth = object : SmoothMoveUtils.OnPositionUpdateListener {
        override fun onUpdate(
            interpolatedLatLng: LatLng,
            bearing: Float
        ) {
//            var gcj = CoordinateTransform.wgs84ToGcj02(
//                interpolatedLatLng.longitude,
//                interpolatedLatLng.latitude
//            )
//            mapOpt.upMyLocCarModel(
//                interpolatedLatLng.latitude,
//                interpolatedLatLng.longitude,
//                bearing
//            )
        }

        override fun onFinish() {
            println("--------------动画完成")
//            carRoadVM.oldVeh = carRoadVM.eVehicle.value
        }

    }



}