package com.sd.demo.ui


import android.os.Bundle
import androidx.appcompat.app.AppCompatActivity
import com.sd.api.core.MapReadyView
import com.sd.api.maps.Layer
import com.sd.api.ui.MapMultiView.OnMapReadyLis
import com.sd.demo.R
import com.sd.demo.databinding.ActivityTlayersBinding


/***切换图层**/
class TLayersActivity : AppCompatActivity() {

    private lateinit var binding: ActivityTlayersBinding

    var mapReadView: MapReadyView? = null

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        binding = ActivityTlayersBinding.inflate(layoutInflater)
        setContentView(binding.root)

        binding.mapMultiView.addMapRenderCallback(object : OnMapReadyLis {
            override fun onMapReady(mapReadyView: MapReadyView) {
                this@TLayersActivity.mapReadView = mapReadyView
                //绘制Marker点 116.3985,39.9079
//                MSCanvesInMap.dMarket(this@TLineActivity, mapReadView, 39.907900, 116.398500)
//                MSMethodAdv.setMapCenter(mapReadView, 39.999391, 116.135972)
            }
        })

        //获取接口功能实例
//        var mapCoreApi = MapCoreApi.mapCoreApi

        binding.rg.setOnCheckedChangeListener { group, checkedId ->
            when (checkedId) {
                R.id.rb1 -> {//普通
                    Layer.toggleLayers(mapReadView, 1)
                }

                R.id.rb2 -> {//卫星
                    Layer.toggleLayers(mapReadView, 2)
                }
            }
        }

    }


}