/*
 * Decompiled with CFR 0.152.
 */
package com.autonavi.base.ae.gmap.glyph;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.os.Build;
import android.text.TextPaint;
import android.text.TextUtils;
import android.util.Log;
import android.view.accessibility.AccessibilityManager;
import com.amap.api.col.3nsl.ad;
import com.autonavi.base.ae.gmap.glyph.Font;
import com.autonavi.base.ae.gmap.glyph.FontMetrics;
import com.autonavi.base.ae.gmap.glyph.FontMetricsRequestParam;
import com.autonavi.base.ae.gmap.glyph.FontStyle;
import com.autonavi.base.ae.gmap.glyph.GlyphMetrics;
import com.autonavi.base.ae.gmap.glyph.GlyphRaster;
import com.autonavi.base.ae.gmap.glyph.GlyphRequestParam;
import com.autonavi.base.ae.gmap.glyph.ReflectUtil;
import com.autonavi.base.amap.mapcore.tools.GLConvertUtil;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;

public class GlyphLoader {
    private static Map<String, Typeface> FontFaceMap = new HashMap<String, Typeface>();

    private static GlyphMetrics loadGlyphMetrics(String string2, FontStyle fontStyle, float f2, String string3, boolean bl2, float f3, boolean bl3, boolean bl4) {
        GlyphMetrics glyphMetrics = new GlyphMetrics();
        if (fontStyle == null) {
            return glyphMetrics;
        }
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return glyphMetrics;
        }
        try {
            if (!bl3) {
                fontStyle = GlyphLoader.newTextPaint(fontStyle, f2, string3, bl2, f3);
                Rect rect = new Rect();
                fontStyle.getTextBounds(string2, 0, string2.length(), rect);
                if (rect.width() == 0 && rect.height() == 0) {
                    float f4 = fontStyle.measureText(" ", 0, 1);
                    float f5 = Math.abs(fontStyle.getFontMetrics().ascent) + Math.abs(fontStyle.getFontMetrics().descent);
                    rect.top = 0;
                    rect.left = 0;
                    rect.right = (int)f4;
                    rect.bottom = (int)f5;
                }
                if (bl2 && f3 > 0.0f) {
                    float f6 = f3 / 2.0f;
                    rect.top = (int)((float)rect.top - f6);
                    rect.left = (int)((float)rect.left - f6);
                    rect.right = (int)((float)rect.right + f6);
                    rect.bottom = (int)((float)rect.bottom + f6);
                }
                glyphMetrics.bSuccess = true;
                glyphMetrics.fLeft = rect.left;
                glyphMetrics.fTop = Math.abs(fontStyle.getFontMetrics().ascent) - (float)Math.abs(rect.top);
                glyphMetrics.nWidth = rect.width();
                glyphMetrics.nHeight = rect.height();
                glyphMetrics.fAdvance = fontStyle.measureText(string2);
                fontStyle.setTypeface(null);
            } else {
                glyphMetrics.bSuccess = true;
                glyphMetrics.fLeft = 0.0f;
                glyphMetrics.fTop = 0.0f;
                glyphMetrics.nWidth = (int)f2;
                glyphMetrics.nHeight = (int)f2;
                glyphMetrics.fAdvance = f2;
            }
        }
        catch (Exception exception) {
            glyphMetrics.bSuccess = false;
        }
        return glyphMetrics;
    }

    private static GlyphRaster loadGlyphRaster(String string2, FontStyle fontStyle, float f2, String string3, boolean bl2, float f3, boolean bl3, boolean bl4) {
        AccessibilityManager accessibilityManager;
        Context context;
        GlyphRaster glyphRaster = new GlyphRaster();
        if (fontStyle == null) {
            return glyphRaster;
        }
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return glyphRaster;
        }
        int n2 = 0;
        try {
            context = ad.a;
            if (context != null) {
                accessibilityManager = (AccessibilityManager)context.getApplicationContext().getSystemService("accessibility");
                n2 = ((Boolean)ReflectUtil.invoke("android.view.accessibility.AccessibilityManager", accessibilityManager, "isHighTextContrastEnabled", null)).booleanValue();
            }
        }
        catch (Throwable throwable) {
            Log.e((String)"HighText", (String)("highText exception:" + throwable.toString()));
        }
        try {
            context = GlyphLoader.newTextPaint(fontStyle, f2, string3, bl2, f3);
            accessibilityManager = new Rect();
            context.getTextBounds(string2, 0, string2.length(), (Rect)accessibilityManager);
            if (accessibilityManager.width() == 0 && accessibilityManager.height() == 0) {
                float f4 = context.measureText(" ", 0, 1);
                float f5 = Math.abs(context.getFontMetrics().ascent) + Math.abs(context.getFontMetrics().descent);
                accessibilityManager.right = (int)f4;
                accessibilityManager.bottom = (int)f5;
                accessibilityManager.left = 0;
                accessibilityManager.top = 0;
            }
            if (bl2 && f3 > 0.0f) {
                float f6 = f3 / 2.0f;
                accessibilityManager.top = (int)((float)accessibilityManager.top - f6);
                accessibilityManager.left = (int)((float)accessibilityManager.left - f6);
                accessibilityManager.right = (int)((float)accessibilityManager.right + f6);
                accessibilityManager.bottom = (int)((float)accessibilityManager.bottom + f6);
            }
            if (!accessibilityManager.isEmpty()) {
                int n3 = 1;
                Bitmap.Config config = Bitmap.Config.ALPHA_8;
                if (bl3 || n2 != 0) {
                    config = Bitmap.Config.ARGB_8888;
                    n3 = 4;
                }
                int n4 = 0;
                if (bl4) {
                    n4 = 3;
                }
                config = Bitmap.createBitmap((int)(accessibilityManager.width() + n4 * 2), (int)(accessibilityManager.height() + n4 * 2), (Bitmap.Config)config);
                Object object = new Canvas((Bitmap)config);
                f3 = 0 - accessibilityManager.left + n4;
                float f7 = 0 - accessibilityManager.top + n4;
                object.drawText(string2, f3, f7, (Paint)context);
                int n5 = accessibilityManager.width() + n4 * 2;
                n4 = accessibilityManager.height() + n4 * 2;
                byte[] byArray = new byte[n5 * n4 * n3];
                object = byArray;
                Object object2 = ByteBuffer.wrap(byArray);
                config.copyPixelsToBuffer((Buffer)object2);
                if (n2 != 0) {
                    object2 = new byte[n5 * n4];
                    for (int i2 = 0; i2 < n4; ++i2) {
                        for (n2 = 0; n2 < n5 * n3; n2 += n3) {
                            object2[n2 / n3 + i2 * n5] = object[n2 + i2 * n5 * n3];
                        }
                    }
                    object = object2;
                }
                glyphRaster.bitmapWidth = n5;
                glyphRaster.bitmapHeight = n4;
                glyphRaster.bitmapPixelMode = bl3 ? 1 : 0;
                glyphRaster.bitmapSize = ((Canvas)object).length;
                glyphRaster.bitmapBuffer = (byte[])object;
                config.recycle();
                glyphRaster.bSuccess = true;
            }
            context.setTypeface(null);
        }
        catch (Exception exception) {
            glyphRaster.bSuccess = false;
        }
        return glyphRaster;
    }

    private static GlyphRequestParam genGlyphRequestParam(byte[] byArray) {
        GlyphRequestParam glyphRequestParam = new GlyphRequestParam();
        int n2 = GLConvertUtil.getInt(byArray, 0);
        glyphRequestParam.strBuffer = new String(byArray, 4, n2);
        int n3 = 4 + n2;
        Font font = new Font();
        new Font().nFontStyleCode = GLConvertUtil.getInt(byArray, n3);
        font.nFontSize = GLConvertUtil.getInt(byArray, n3 += 4);
        n2 = GLConvertUtil.getInt(byArray, n3 += 4);
        font.strName = new String(byArray, n3 += 4, n2);
        FontMetrics fontMetrics = new FontMetrics();
        int n4 = GLConvertUtil.getInt(byArray, n3 += n2);
        fontMetrics.fAscent = (float)n4 * 0.001f;
        n4 = GLConvertUtil.getInt(byArray, n3 += 4);
        fontMetrics.fDescent = (float)n4 * 0.001f;
        n4 = GLConvertUtil.getInt(byArray, n3 += 4);
        fontMetrics.fLeading = (float)n4 * 0.001f;
        n4 = GLConvertUtil.getInt(byArray, n3 += 4);
        fontMetrics.fHeight = (float)n4 * 0.001f;
        font.fontMetrics = fontMetrics;
        glyphRequestParam.font = font;
        glyphRequestParam.drawingMode = GLConvertUtil.getInt(byArray, n3 += 4);
        n4 = GLConvertUtil.getInt(byArray, n3 += 4);
        glyphRequestParam.strokeWidth = (float)n4 * 0.001f;
        int n5 = GLConvertUtil.getInt(byArray, n3 += 4);
        glyphRequestParam.languageArr = new String(byArray, n3 += 4, n5);
        glyphRequestParam.isEmoji = GLConvertUtil.getInt(byArray, n3);
        glyphRequestParam.isSDF = GLConvertUtil.getInt(byArray, n3 += 4);
        n5 = GLConvertUtil.getInt(byArray, n3 += 4);
        n3 += 4;
        if (1 == n5) {
            GlyphMetrics glyphMetrics = new GlyphMetrics();
            new GlyphMetrics().nWidth = GLConvertUtil.getInt(byArray, n3);
            glyphMetrics.nHeight = GLConvertUtil.getInt(byArray, n3 += 4);
            n4 = GLConvertUtil.getInt(byArray, n3 += 4);
            glyphMetrics.fLeft = (float)n4 * 0.001f;
            n4 = GLConvertUtil.getInt(byArray, n3 += 4);
            glyphMetrics.fTop = (float)n4 * 0.001f;
            n4 = GLConvertUtil.getInt(byArray, n3 += 4);
            glyphMetrics.fAdvance = (float)n4 * 0.001f;
            glyphRequestParam.fGlyphMetrics = glyphMetrics;
        }
        return glyphRequestParam;
    }

    private static FontMetricsRequestParam genFontMetricsParam(byte[] byArray) {
        FontMetricsRequestParam fontMetricsRequestParam = new FontMetricsRequestParam();
        int n2 = 0;
        int n3 = GLConvertUtil.getInt(byArray, 0);
        n2 += 4;
        fontMetricsRequestParam.fFontSize = (float)n3 * 0.001f;
        fontMetricsRequestParam.nFontStyleCode = GLConvertUtil.getInt(byArray, 4);
        n2 += 4;
        n3 = GLConvertUtil.getInt(byArray, 8);
        n2 += 4;
        if (1 == n3) {
            n3 = GLConvertUtil.getInt(byArray, 12);
            fontMetricsRequestParam.strName = new String(byArray, 16, n3);
            n2 = 16 + n3;
        }
        n3 = GLConvertUtil.getInt(byArray, n2);
        fontMetricsRequestParam.languageArr = new String(byArray, n2 += 4, n3);
        return fontMetricsRequestParam;
    }

    private static GlyphMetrics getGlyphMetrics(byte[] object) {
        object = GlyphLoader.genGlyphRequestParam(object);
        FontStyle fontStyle = new FontStyle(object.font.nFontStyleCode);
        boolean bl2 = false;
        if (object.drawingMode != 0) {
            bl2 = true;
        }
        return GlyphLoader.loadGlyphMetrics(object.strBuffer, fontStyle, object.font.nFontSize, object.font.strName, bl2, object.strokeWidth, object.isEmoji > 0, object.isSDF > 0);
    }

    private static GlyphRaster getGlyphRaster(byte[] object) {
        object = GlyphLoader.genGlyphRequestParam(object);
        FontStyle fontStyle = new FontStyle(object.font.nFontStyleCode);
        boolean bl2 = false;
        if (object.drawingMode != 0) {
            bl2 = true;
        }
        if (object.drawingMode == 3) {
            return GlyphLoader.loadPathRaster(object.strBuffer, fontStyle, object.font.nFontSize, object.font.strName, bl2, object.strokeWidth * 2.0f);
        }
        return GlyphLoader.loadGlyphRaster(object.strBuffer, fontStyle, object.font.nFontSize, object.font.strName, bl2, object.strokeWidth, object.isEmoji > 0, object.isSDF > 0);
    }

    public static GlyphRaster loadPathRaster(String object, FontStyle fontStyle, float f2, String string2, boolean bl2, float f3) {
        GlyphRaster glyphRaster = new GlyphRaster();
        if (fontStyle == null) {
            return glyphRaster;
        }
        if (TextUtils.isEmpty((CharSequence)object)) {
            return glyphRaster;
        }
        try {
            TextPaint textPaint = GlyphLoader.newTextPaint(fontStyle, f2, string2, false, 0.0f);
            Rect rect = new Rect();
            textPaint.getTextBounds((String)object, 0, ((String)object).length(), rect);
            Bitmap bitmap = Bitmap.createBitmap((int)rect.width(), (int)rect.height(), (Bitmap.Config)Bitmap.Config.ALPHA_8);
            bitmap = new Canvas(bitmap);
            float f4 = 0 - rect.left;
            float f5 = 0 - rect.top;
            bitmap.drawText((String)object, f4, f5, (Paint)textPaint);
            fontStyle = GlyphLoader.newTextPaint(fontStyle, f2, string2, bl2, f3);
            Rect rect2 = new Rect();
            fontStyle.getTextBounds((String)object, 0, ((String)object).length(), rect2);
            if (bl2 && f3 > 0.0f) {
                float f6 = f3 * 0.5f;
                rect2.top = (int)((float)rect2.top - f6);
                rect2.left = (int)((float)rect2.left - f6);
                rect2.right = (int)((float)rect2.right + f6);
                rect2.bottom = (int)((float)rect2.bottom + f6);
            }
            if (!rect2.isEmpty()) {
                Bitmap bitmap2 = Bitmap.createBitmap((int)rect2.width(), (int)rect2.height(), (Bitmap.Config)Bitmap.Config.ALPHA_8);
                Object object2 = new Canvas(bitmap2);
                f3 = 0 - rect2.left;
                f5 = 0 - rect2.top;
                bitmap = new Path();
                textPaint.getTextPath((String)object, 0, ((String)object).length(), f3, f5, (Path)bitmap);
                object2.drawPath((Path)bitmap, (Paint)fontStyle);
                byte[] byArray = new byte[rect2.width() * rect2.height()];
                object = byArray;
                object2 = ByteBuffer.wrap(byArray);
                glyphRaster.bitmapWidth = rect2.width();
                glyphRaster.bitmapHeight = rect2.height();
                glyphRaster.bitmapPixelMode = 0;
                glyphRaster.bitmapSize = ((Object)object).length;
                bitmap2.copyPixelsToBuffer((Buffer)object2);
                bitmap2.recycle();
                glyphRaster.bitmapBuffer = (byte[])object;
                glyphRaster.bSuccess = true;
            }
            textPaint.setTypeface(null);
            fontStyle.setTypeface(null);
        }
        catch (Exception exception) {
            glyphRaster.bSuccess = false;
        }
        return glyphRaster;
    }

    private static FontMetrics getFontMetrics(byte[] object) {
        object = GlyphLoader.genFontMetricsParam(object);
        TextPaint textPaint = GlyphLoader.newTextPaint(new FontStyle(object.nFontStyleCode), object.fFontSize, object.strName, false, 0.0f);
        object = textPaint;
        Paint.FontMetrics fontMetrics = textPaint.getFontMetrics();
        FontMetrics fontMetrics2 = new FontMetrics();
        new FontMetrics().bSuccess = true;
        fontMetrics2.fAscent = Math.abs(fontMetrics.ascent);
        fontMetrics2.fDescent = Math.abs(fontMetrics.descent);
        fontMetrics2.fLeading = Math.abs(fontMetrics.leading);
        fontMetrics2.fHeight = Math.abs(fontMetrics.ascent) + Math.abs(fontMetrics.descent);
        object.setTypeface(null);
        return fontMetrics2;
    }

    private static String decodeUnicode(short s2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append((char)s2);
        return stringBuffer.toString();
    }

    private static String decodeUnicode(String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string2);
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static TextPaint newTextPaint(FontStyle fontStyle, float f2, String string2, boolean bl2, float f3) {
        Typeface typeface;
        int n2;
        boolean bl3;
        boolean bl4;
        TextPaint textPaint = new TextPaint();
        if (fontStyle == null) {
            return textPaint;
        }
        textPaint.setColor(-1);
        textPaint.setAntiAlias(true);
        textPaint.setFilterBitmap(true);
        textPaint.setTextSize(f2);
        textPaint.setTextAlign(Paint.Align.LEFT);
        if (bl2) {
            void var4_11;
            textPaint.setStyle(Paint.Style.STROKE);
            textPaint.setStrokeWidth((float)var4_11);
        } else {
            textPaint.setStyle(Paint.Style.FILL);
        }
        switch (fontStyle.getSlant()) {
            case 0: {
                bl4 = false;
                break;
            }
            case 1: 
            case 2: {
                bl4 = true;
                break;
            }
            default: {
                bl4 = false;
            }
        }
        switch (fontStyle.getWeight()) {
            case 400: {
                bl3 = false;
                break;
            }
            case 0: 
            case 100: 
            case 200: 
            case 300: {
                bl3 = false;
                break;
            }
            case 500: 
            case 600: 
            case 700: 
            case 800: 
            case 900: 
            case 1000: {
                bl3 = true;
                break;
            }
            default: {
                bl3 = false;
            }
        }
        boolean bl5 = false;
        if (bl3 && bl4) {
            textPaint.setFakeBoldText(true);
        } else if (bl3) {
            textPaint.setFakeBoldText(true);
        } else if (bl4) {
            n2 = 2;
        }
        bl3 = true;
        try {
            if (Build.VERSION.SDK_INT >= 23) {
                bl3 = false;
            }
        }
        catch (NumberFormatException numberFormatException) {
            bl3 = true;
        }
        if (string2.isEmpty() || bl3) {
            typeface = Typeface.create((Typeface)Typeface.DEFAULT, (int)n2);
        } else {
            try {
                Map<String, Typeface> map = FontFaceMap;
                synchronized (map) {
                    typeface = FontFaceMap.get(string2);
                    if (typeface == null) {
                        typeface = Typeface.createFromFile((String)string2);
                        FontFaceMap.put(string2, typeface);
                    }
                }
            }
            catch (Exception exception) {
                typeface = Typeface.create((Typeface)Typeface.DEFAULT, (int)n2);
            }
        }
        textPaint.setTypeface(typeface);
        return textPaint;
    }

    public static long createGlyphLoader() {
        return GlyphLoader.nativeCreateGlyphLoader();
    }

    public static void destroyGlyphLoader(long l2) {
        GlyphLoader.nativeDestroyGlyphLoader(l2);
    }

    private static native long nativeCreateGlyphLoader();

    private static native void nativeDestroyGlyphLoader(long var0);
}

