/*
 * Decompiled with CFR 0.152.
 */
package com.amap.api.navi.view;

import android.content.Context;
import android.content.res.Resources;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.TranslateAnimation;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.amap.api.col.3nsl.id;
import com.amap.api.navi.model.NaviPoi;
import com.amap.api.navi.view.PoiInputSearchWidget;

public class PoiInputItemWidget
extends RelativeLayout
implements View.OnClickListener {
    public static final int TYPE_START = 0;
    public static final int TYPE_DEST = 1;
    public static final int TYPE_MIDDLE = 2;
    public static final int SWITCH_ANIMATION_UP = 0;
    public static final int SWITCH_ANIMATION_DOWN = 1;
    public int middle_index = -1;
    private Callback mCallback;
    private TextView mTypeTV;
    private ImageView mDeleteIV;
    private TextView mPoiTV;
    private int mType;
    private NaviPoi mPoi;
    private Resources mResources;
    private int animDuration = 150;

    public PoiInputItemWidget(Context context) {
        super(context);
        this.init();
    }

    public PoiInputItemWidget(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.init();
    }

    public PoiInputItemWidget(Context context, AttributeSet attributeSet, int n2) {
        super(context, attributeSet, n2);
        this.init();
    }

    private void init() {
        id.a(this.getContext(), 2130903068, (ViewGroup)this);
        this.mResources = id.b(this.getContext());
        PoiInputItemWidget poiInputItemWidget = this;
        poiInputItemWidget.setBackgroundDrawable(poiInputItemWidget.mResources.getDrawable(2130837783));
        this.mTypeTV = (TextView)this.findViewById(2147479838);
        this.mDeleteIV = (ImageView)this.findViewById(0x7FFFF11F);
        this.mPoiTV = (TextView)this.findViewById(2147479840);
        this.mTypeTV.setOnClickListener((View.OnClickListener)this);
        this.mPoiTV.setOnClickListener((View.OnClickListener)this);
        this.mDeleteIV.setOnClickListener((View.OnClickListener)this);
    }

    public void setCallback(Callback callback) {
        this.mCallback = callback;
    }

    public void initUI(int n2, NaviPoi naviPoi) {
        this.mType = n2;
        this.mPoi = naviPoi;
        if (n2 == 2) {
            this.mDeleteIV.setVisibility(0);
            this.mTypeTV.setVisibility(8);
            this.setPoiForMid(naviPoi);
            return;
        }
        this.mDeleteIV.setVisibility(8);
        this.mTypeTV.setVisibility(0);
        String string2 = this.getTypeStr(n2);
        this.mTypeTV.setText((CharSequence)string2);
        if (naviPoi == null || TextUtils.isEmpty((CharSequence)naviPoi.getName())) {
            this.mPoiTV.setText((CharSequence)"");
            this.mPoiTV.setHint((CharSequence)this.getHintStr(n2));
            return;
        }
        this.mPoiTV.setText((CharSequence)naviPoi.getName());
    }

    public void setPoi(NaviPoi naviPoi) {
        PoiInputItemWidget poiInputItemWidget = this;
        poiInputItemWidget.initUI(poiInputItemWidget.mType, naviPoi);
    }

    private String getHintStr(int n2) {
        if (n2 == 0) {
            return "\u8bf7\u8f93\u5165\u8d77\u70b9";
        }
        return "\u8bf7\u8f93\u5165\u7ec8\u70b9";
    }

    public void setViaIndex(int n2) {
        if (this.mType != 2 || this.mPoi != null) {
            return;
        }
        if (n2 > 0) {
            this.mPoiTV.setHint((CharSequence)(this.mResources.getString(2131230731) + n2));
            return;
        }
        this.mPoiTV.setHint((CharSequence)this.mResources.getString(2131230731));
    }

    public int getType() {
        return this.mType;
    }

    public NaviPoi getPoi() {
        return this.mPoi;
    }

    private void setPoiForMid(NaviPoi naviPoi) {
        if (naviPoi == null) {
            this.mPoiTV.setText((CharSequence)"");
            if (this.middle_index >= 0) {
                this.mPoiTV.setHint((CharSequence)(this.mResources.getString(2131230731) + (this.middle_index + 1)));
                return;
            }
            this.mPoiTV.setHint((CharSequence)this.mResources.getString(2131230731));
            return;
        }
        this.mPoiTV.setText((CharSequence)naviPoi.getName());
    }

    private String getTypeStr(int n2) {
        switch (n2) {
            case 0: {
                return this.mResources.getString(2131230728);
            }
            case 1: {
                return this.mResources.getString(2131230729);
            }
        }
        return "";
    }

    public void onClick(View view) {
        try {
            int n2 = view.getId();
            if (n2 == 2147479838 || n2 == 2147479840) {
                if (this.mCallback != null) {
                    this.mCallback.onClick(this);
                    return;
                }
            } else if (n2 == 0x7FFFF11F && this.mCallback != null) {
                this.mCallback.onDelete(this);
            }
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    public void switchAnim(int n2, final Runnable runnable) {
        TextView textView = this.mPoiTV;
        switch (n2) {
            case 0: {
                this.mid2Up((View)textView, new PoiInputSearchWidget.AnimationListenerAdapter((View)textView){
                    final /* synthetic */ View b;
                    {
                        this.b = view;
                    }

                    @Override
                    public final void onAnimationEnd(Animation animation) {
                        PoiInputItemWidget.this.post(runnable);
                        PoiInputItemWidget.this.up2Mid(this.b, null);
                    }
                });
                return;
            }
            case 1: {
                this.mid2Down((View)textView, new PoiInputSearchWidget.AnimationListenerAdapter((View)textView){
                    final /* synthetic */ View b;
                    {
                        this.b = view;
                    }

                    @Override
                    public final void onAnimationEnd(Animation animation) {
                        PoiInputItemWidget.this.post(runnable);
                        PoiInputItemWidget.this.down2Mid(this.b, null);
                    }
                });
            }
        }
    }

    private void down2Mid(View view, PoiInputSearchWidget.AnimationListenerAdapter animationListenerAdapter) {
        TranslateAnimation translateAnimation = new TranslateAnimation(0.0f, 0.0f, (float)this.getHeight(), 0.0f);
        translateAnimation.setDuration((long)this.animDuration);
        translateAnimation.setAnimationListener((Animation.AnimationListener)animationListenerAdapter);
        view.startAnimation((Animation)translateAnimation);
    }

    private void mid2Up(View view, PoiInputSearchWidget.AnimationListenerAdapter animationListenerAdapter) {
        TranslateAnimation translateAnimation = new TranslateAnimation(0.0f, 0.0f, 0.0f, (float)(-this.getHeight()));
        translateAnimation.setDuration((long)this.animDuration);
        translateAnimation.setAnimationListener((Animation.AnimationListener)animationListenerAdapter);
        view.startAnimation((Animation)translateAnimation);
    }

    private void up2Mid(View view, PoiInputSearchWidget.AnimationListenerAdapter animationListenerAdapter) {
        TranslateAnimation translateAnimation = new TranslateAnimation(0.0f, 0.0f, (float)(-this.getHeight()), 0.0f);
        translateAnimation.setDuration((long)this.animDuration);
        translateAnimation.setAnimationListener((Animation.AnimationListener)animationListenerAdapter);
        view.startAnimation((Animation)translateAnimation);
    }

    private void mid2Down(View view, PoiInputSearchWidget.AnimationListenerAdapter animationListenerAdapter) {
        TranslateAnimation translateAnimation = new TranslateAnimation(0.0f, 0.0f, 0.0f, (float)this.getHeight());
        translateAnimation.setDuration((long)this.animDuration);
        translateAnimation.setAnimationListener((Animation.AnimationListener)animationListenerAdapter);
        view.startAnimation((Animation)translateAnimation);
    }

    public static interface Callback {
        public void onClick(PoiInputItemWidget var1);

        public void onDelete(PoiInputItemWidget var1);

        public void onBack();

        public void onAddMid();
    }
}

