package com.sd.api.maps.mine

import com.minedata.minenavi.mapdal.PoiItem
import com.minedata.minenavi.poiquery.LatLonPoint
import com.minedata.minenavi.poiquery.PoiResult
import com.minedata.minenavi.poiquery.PoiSearch
import com.minedata.minenavi.poiquery.SearchErrorCode
import com.minedata.minenavi.poiquery.SortType
import com.sd.api.UserCtx
import com.sd.api.maps.cdata.PoiSearchRes
import com.sd.api.maps.inters.OnMSPoiSearchLis

/**
 * 四维Poi搜索相关
 **/
object MinePoiSearch : PoiSearch.OnPoiSearchListener {


    private var onMSPoiSearchLis: OnMSPoiSearchLis? = null


    /**关键字搜索
     * @param keyWord 关键字
     * @param lat 当期维度
     * @param lng 当期经度
     * @param onMSPoiSearchLis 搜索回调
     */
    fun startPoiSearch(
        keyWord: String,
        lat: Double = 41.80196,
        lng: Double = 123.43326,
        onMSPoiSearchLis: OnMSPoiSearchLis
    ) {
        this.onMSPoiSearchLis = onMSPoiSearchLis
        var context = UserCtx.Companion.instance.mContext
        val poiSearch = PoiSearch(context)
        poiSearch.setOnPoiSearchListener(this)
        val query = PoiSearch.Query(keyWord, "", "").apply {
            // 设置查询位置点
            location = LatLonPoint(lat, lng)
            // 限制严格按照设置城市搜索
            setCityLimit(false)
            // 设置排序方式为热度排序
            setSortType(SortType.SORT_TYPE_HIT)
            // 返回父子关系
            requireSubPois(true)
            pageNum = 0
            setPageSize(20)// 设置每页最多返回多少条poiitem
        }
        poiSearch.query = query
        poiSearch.searchPOIAsyn()

    }

    /**周边搜索
     * @param keyWord 关键字
     * @param lat 当前维度
     * @param lng 当前经度
     * @param radios 搜索半径(单位 米)
     * @param onMSPoiSearchLis 回调
     */
    fun startPoiSearchBound(
        keyWord: String,
        lat: Double,
        lng: Double,
        radios: Int,
        onMSPoiSearchLis: OnMSPoiSearchLis
    ) {
        this.onMSPoiSearchLis = onMSPoiSearchLis
        var context = UserCtx.Companion.instance.mContext
        val poiSearch = PoiSearch(context)
        poiSearch.setOnPoiSearchListener(this)

        // 第一个参数表示搜索中心点， 第二个参数表示搜索半径
        val bound = PoiSearch.SearchBound(LatLonPoint(lat, lng), radios)
        poiSearch.setBound(bound)
// 第一个参数表示搜索关键字（可传空字符串），
// 第二个参数表示 POI 搜索类型，不同类型用|分割，
// 第三个参数表示 POI 搜索城市编码
        val query = PoiSearch.Query(keyWord, "", "").apply {
            // 设置查询位置点
            location = LatLonPoint(lat, lng)
            // 限制严格按照设置城市搜索
            setCityLimit(true)
            // 设置排序方式为热度排序
            setSortType(SortType.SORT_TYPE_HIT)
            // 返回父子关系
            requireSubPois(true)
            pageNum = 0
            setPageSize(20)// 设置每页最多返回多少条poiitem
        }

        poiSearch.query = query
        poiSearch.searchPOIAsyn()
    }


    //---------------------------------四维POI 返回 -------------------------------
    override fun onPoiItemSearched(p0: PoiItem?, p1: Int) {
        var b = 0
    }

    override fun onPoiSearched(result: PoiResult?, rCode: Int) {
        if (rCode == SearchErrorCode.none) {
            var temps = result?.getPois()
            var poiList = temps!!.map { pos ->
                PoiSearchRes().apply {
                    lat = pos.location.latitude
                    lng = pos.location.longitude
                    title = pos.title
                    snippet = pos.snippet
                    cityName = pos.cityName
                    //这里为0 因为不是范围搜索
                    distance = pos.distance
                    adCode = pos.adCode
                }
            }
            onMSPoiSearchLis?.onPoiLis(poiList)
        } else {
            onMSPoiSearchLis?.onPoiLis(listOf())
        }
    }

}