package com.sd.api.maps.amap

import com.amap.api.services.core.AMapException
import com.amap.api.services.core.LatLonPoint
import com.amap.api.services.core.PoiItem
import com.amap.api.services.poisearch.PoiResult
import com.amap.api.services.poisearch.PoiSearch
import com.sd.api.UserCtx
import com.sd.api.maps.cdata.PoiSearchRes
import com.sd.api.maps.inters.OnMSPoiSearchLis

/**
 * 高配的Poi 搜索相关
 */
object AmapPoiSearch : PoiSearch.OnPoiSearchListener {


    private var onMSPoiSearchLis: OnMSPoiSearchLis? = null


    /**关键字搜索
     * @param keyWord 关键字
     * @param lat 当期维度
     * @param lng 当期经度
     * @param onMSPoiSearchLis 搜索回调
     */
    fun startPoiSearch(
        keyWord: String,
        lat: Double = 41.80196,
        lng: Double = 123.43326,
        onMSPoiSearchLis: OnMSPoiSearchLis
    ) {
        this.onMSPoiSearchLis = onMSPoiSearchLis
        var context = UserCtx.Companion.instance.mContext

        var query = PoiSearch.Query(keyWord, "", "").apply {
            location = LatLonPoint(lat, lng)
            cityLimit = false
            // 返回父子关系
            requireSubPois(true)
            pageNum = 1
            pageSize = 20
        }
        var poiSearch = PoiSearch(context, query)
        poiSearch.setOnPoiSearchListener(this)
        poiSearch.searchPOIAsyn()

    }

    /**周边搜索
     * @param keyWord 关键字
     * @param lat 当前维度
     * @param lng 当前经度
     * @param radios 搜索半径(单位 米)
     * @param onMSPoiSearchLis 回调
     */
    fun startPoiSearchBound(
        keyWord: String,
        lat: Double,
        lng: Double,
        radios: Int,
        onMSPoiSearchLis: OnMSPoiSearchLis
    ) {
        this.onMSPoiSearchLis = onMSPoiSearchLis
        var context = UserCtx.Companion.instance.mContext


        var query = PoiSearch.Query(keyWord, "", "").apply {
            location = LatLonPoint(lat, lng)
            cityLimit = true
            // 返回父子关系
            requireSubPois(true)
            pageNum = 1
            pageSize = 20
        }
        var poiSearch = PoiSearch(context, query)
        poiSearch.setOnPoiSearchListener(this)
        poiSearch.setBound(PoiSearch.SearchBound(LatLonPoint(lat, lng), radios, true))

        poiSearch.searchPOIAsyn()

    }


    //--------------------------------高德POI 搜索- -------------------------------

    override fun onPoiSearched(result: PoiResult?, rCode: Int) {
        if (rCode == AMapException.CODE_AMAP_SUCCESS) {
            if (result != null && result.getQuery() != null) {// 搜索poi的结果
                var temps = result?.getPois()
                var poiList = temps!!.map { pos ->
                    PoiSearchRes().apply {
                        lat = pos.latLonPoint.latitude
                        lng = pos.latLonPoint.longitude
                        title = pos.title
                        snippet = pos.snippet
                        cityName = pos.cityName
                        //这里为0 因为不是范围搜索
                        distance = pos.distance
                        adCode = pos.adCode
                    }
                }
                onMSPoiSearchLis?.onPoiLis(poiList)
            }
        } else {
            onMSPoiSearchLis?.onPoiLis(listOf())
        }
    }

    override fun onPoiItemSearched(p0: PoiItem?, p1: Int) {
    }

}