package com.sd.api.maps

import com.sd.api.MAP_TYPE
import com.sd.api.MSDKInitializer
import com.sd.api.ui.MapReadyView
import com.sd.api.maps.amap.AmapLayers
import com.sd.api.maps.mine.MineLayers

/**
 * 图层操作
 */
object Layer {

    /**
     * 切换地图图层
     * @param mapReadView 地图准备就绪视图对象
     * @param type 1=普通 2=卫星
     */
    fun toggleLayers(mapReadView: MapReadyView?, type: Int) {
        when (MSDKInitializer.getMapType()) {
            MAP_TYPE.MINE -> {
                MineLayers.toggleLayers(mapReadView, type)
            }

            MAP_TYPE.AMAP -> {
                AmapLayers.toggleLayers(mapReadView, type)
            }
        }
    }


}