package com.sd.api.maps

import com.sd.api.MAP_TYPE
import com.sd.api.MSDKInitializer
import com.sd.api.ui.MapReadyView
import com.sd.api.maps.amap.AmapGestures
import com.sd.api.maps.mine.MineGestures

/**
 * 手势控制
 */
object Gestures{

    /**
     * 设置地图旋转手势是否可用
     * @param mapReadView 地图准备就绪视图对象
     * @param enable 是否启用旋转手势功能
     */
    fun setRotateGesturesEnabled(mapReadView: MapReadyView?, enable: Boolean){
        when (MSDKInitializer.getMapType()) {
            MAP_TYPE.MINE -> {
                MineGestures.setRotateGesturesEnabled(mapReadView, enable)
            }

            MAP_TYPE.AMAP -> {
                AmapGestures.setRotateGesturesEnabled(mapReadView, enable)
            }
        }
    }


    /**
     * 设置地图倾斜手势功能的启用状态
     * @param mapReadView 地图准备就绪视图对象
     * @param enable 是否启用倾斜手势功能，true为启用，false为禁用
     * */
    fun setTiltGesturesEnabled(mapReadView: MapReadyView?, enable: Boolean){
        when (MSDKInitializer.getMapType()) {
            MAP_TYPE.MINE -> {
                MineGestures.setTiltGesturesEnabled(mapReadView, enable)
            }

            MAP_TYPE.AMAP -> {
                AmapGestures.setTiltGesturesEnabled(mapReadView, enable)
            }
        }
    }
}