package com.sd.api.location

import android.os.Bundle
import com.minedata.minenavi.location.MineLocation
import com.minedata.minenavi.location.MineLocationListener
import com.minedata.minenavi.location.MineLocationManager
import com.minedata.minenavi.location.MineLocationOptions
import com.minedata.minenavi.mapdal.CoordType
import com.sd.api.UserCtx

/**GPS定位类*/
object MineGpsLocation {


    //  设置四维定位参数，并开始定位。
    private val options: MineLocationOptions by lazy {
        MineLocationOptions().apply {
            setCoordType(CoordType.GCJ02)
            setGpsInterval(1000)//GPS定位更新时间，最小1000
            setNetWorkInterval(3000)//WiFi定位更新时间，最小3000
            setStationInterval(5000)//基站定位更新时间，最小500
        }
    }


    /**业务层Gps定位回调**/
    private var onMsGpsLoc: OnMsGpsLoc? = null

    /**初始化定位*/
    private fun initLoc() {
        var context = UserCtx.Companion.instance.mContext
        MineLocationManager.getInstance()
            .init(context, MineLocationManager.LocationSource.gpsAndNetwork)
//                MineLocationManager.getInstance().removeListener(mineLocationListener)
        MineLocationManager.getInstance().addListener(mineLocationListener)
    }


    /**开启定位*/
    fun starLoc(onMsGpsLoc: OnMsGpsLoc) {
        initLoc()
        this.onMsGpsLoc = onMsGpsLoc
        MineLocationManager.getInstance().start(options)
    }

    /**停止定位*/
    fun stopLoc() {
        MineLocationManager.getInstance().removeAllListener()
        MineLocationManager.getInstance().stop()
    }

    /**清理定位资源**/
    fun cleansLoc() {
        MineLocationManager.getInstance().cleanup()
    }


    //---------------四维回调---------------
    private var mineLocationListener = object : MineLocationListener {
        override fun onSimLocationChanged(location: MineLocation?) {
        }

        override fun onLocationChanged(location: MineLocation?) {
//            println("-------四维定位改变 = ${location?.latitude}   curLng=${location?.longitude}  speed=${location?.speed}")
            var loc = MSLocCb.Companion.instance.apply {
                lat = location?.latitude ?: 0.0
                lng = location?.longitude ?: 0.0
                speed = location?.speed ?: 0f
                bearing = location?.bearing ?: 0f
                accuracy = location?.accuracy ?: 0f
                altitude = location?.altitude ?: 0.0
            }
            onMsGpsLoc?.onMsGpsLoc(loc)
        }

        override fun onStatusChanged(provider: String?, status: Int, extras: Bundle?) {
        }

        override fun onProviderEnabled(provider: String?) {
        }

        override fun onProviderDisabled(provider: String?) {
        }

    }


}