package com.sd.api.intfaces

import com.minedata.minenavi.mapdal.PoiFavorite
import com.minedata.minenavi.navi.ArrowInfo
import com.minedata.minenavi.navi.BusRoute
import com.minedata.minenavi.navi.GuidanceText
import com.minedata.minenavi.navi.MineNaviListener
import com.minedata.minenavi.navi.NaviProgressData
import com.minedata.minenavi.navi.NaviSessionData
import com.minedata.minenavi.navi.RouteBase
import com.minedata.minenavi.navi.RouteBriefQuerier
import com.minedata.minenavi.navi.RouteCollection
import com.minedata.minenavi.navi.RouterErrorInfo
import com.minedata.minenavi.navi.SmoothNaviData
import com.minedata.minenavi.navi.TmcSections

/**
 * 四维导航监听
 */
abstract class MyMineNaviListener : MineNaviListener {
    override fun onCalculateRouteSuccess(data: RouteCollection) {
        // 路线规划成功
    }

    override fun onCalculateBusSuccess(p0: List<BusRoute?>?) {

    }

    override fun onCalculateRouteFailed(data: RouterErrorInfo) {
        // 路线规划失败
    }

    override fun onCalculateVrpSuccess(p0: List<PoiFavorite?>?) {
    }

    /**到达目的地后回调函数*/
    override fun onArriveDestination() {
    }

    override fun onWayPointArrived(p0: Int) {
    }

    //当前有新的转弯箭头需要显示回调函数
    override fun onNewArrow(arrowInfo: ArrowInfo) {
    }

    override fun onDeleteArrow() {
    }



    override fun onRouteRemoved() {
    }

    override fun onNeedsReroute() {
    }

    override fun onRerouteCancelled() {
    }

    override fun onRerouteComplete(data: RouteBase?) {
    }

    override fun onRerouteFailed(p0: RouterErrorInfo) {
    }

    override fun onRerouteStarted() {
    }

    override fun onRouteCancelled() {
    }

    override fun onRouteStarted() {
    }

    override fun onRouting() {
    }

    override fun onNewRouteTaken(data: RouteBase?) {
    }

    override fun onNaviBegin(data: RouteBase?) {
    }

    override fun onSimNaviBegin(data: RouteBase?) {
    }

    override fun onSimNaviPaused(data: RouteBase?) {
    }

    override fun onSimNaviResumed(data: RouteBase?) {
    }

    override fun onSimNaviEnd(data: RouteBase?) {
    }

    /**
     * 导航结束
     */
    override fun onNaviEnded() {

    }

    /**
     * 车位置发生改变
     */
    override fun onTracking(data: NaviSessionData) {
    }

    /**
     * 导航或者模拟导航时平滑跟踪
     */
    override fun onSmoothTracking(data: SmoothNaviData) {
    }

    /**
     * 解析 naviProgressData 导航更新信息
     */
    override fun onDataUpdated(naviProgressData: NaviProgressData) {
    }

    /**
     * 引导文字改变
     */
    override fun onTextChanged(guidanceText: GuidanceText) {
    }

    /**
     * 导航路口剩余距离
     */
    override fun onDistanceChanged(distance: Int) {
    }

    /**
     * 解析 tmcSections 路况(TMC)信息条中的段信息
     * **/
    override fun onTiBarUpdated(tmcSections: TmcSections) {
    }

    override fun onRouteTmcUpdated(p0: RouteBase?) {
    }

    override fun onRouteTeUpdated(p0: RouteBase?) {
    }

    override fun onRouteBriefRequestSucceeded(p0: RouteBriefQuerier.RouteBrief?) {
    }

    override fun onRouteBriefRequestFailed(p0: Int, p1: String?) {
    }

    override fun onRouteBriefRequestCancelled() {
    }
}