package com.sd.api.fragments

import android.os.Bundle
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import androidx.fragment.app.Fragment
import com.minedata.minenavi.map.MineMap
import com.msmap.api.databinding.FragmentForeMapBinding
import com.sd.api.ui.MapReadyView
import com.sd.api.ui.MapMultiView.OnMapReadyLis

// the fragment initialization parameters, e.g. ARG_ITEM_NUMBER
//private const val ARG_PARAM1 = "param1"
//private const val ARG_PARAM2 = "param2"

/**
 *四维地图容器
 */
class ForeMapFragment : Fragment() {
//    private var param1: String? = null
//    private var param2: String? = null

//    override fun onCreate(savedInstanceState: Bundle?) {
//        super.onCreate(savedInstanceState)
//        arguments?.let {
//            param1 = it.getString(ARG_PARAM1)
//            param2 = it.getString(ARG_PARAM2)
//        }
//    }

    override fun onCreateView(
        inflater: LayoutInflater, container: ViewGroup?,
        savedInstanceState: Bundle?
    ): View {
        binding = FragmentForeMapBinding.inflate(inflater, container, false)
        // Inflate the layout for this fragment
        return binding.root
    }


    private lateinit var binding: FragmentForeMapBinding


    //跳转到搜索界面
  /*  private var searchAct =
        registerForActivityResult(ActivityResultContracts.StartActivityForResult(), { result ->
            if (result.resultCode == Activity.RESULT_OK) {
                val intent = result.data
                val returnedData = intent?.getStringExtra("123")
                Log.d("----", "----Returned data: $returnedData")
            }
        })*/


    private var mMineMap: MineMap? = null

    private var onMapReadyLis: OnMapReadyLis? = null

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        super.onViewCreated(view, savedInstanceState)
        initView()
        setLis()
    }

    private fun initView() {

    }

    private fun setLis() {
        binding.mapView.addMapRenderCallback { mineMap ->
            this.mMineMap = mineMap
            MapReadyView.instance.mMineMap = mineMap
            MapReadyView.instance.fMapView = binding.mapView
            onMapReadyLis?.onMapReady(MapReadyView.instance)
        }
    }

    /**地图加载完成监听回调*/
    fun addMapRenderCallback(onMapReadyLis: OnMapReadyLis) {
        this.onMapReadyLis = onMapReadyLis
    }

    fun getAnyMap(): MineMap? {
        return mMineMap
    }

    override fun onPause() {
        super.onPause()
        binding.mapView.onPause()
    }

    override fun onResume() {
        super.onResume()
        binding.mapView.onResume()
    }

    override fun onDestroy() {
        super.onDestroy()
        binding.mapView.onDestroy()
    }

    companion object {
        @JvmStatic
        fun newInstance() = ForeMapFragment()

//        @JvmStatic
//        fun newInstance(param1: String, param2: String) =
//            ForeMapFragment().apply {
//                arguments = Bundle().apply {
//                    putString(ARG_PARAM1, param1)
//                    putString(ARG_PARAM2, param2)
//                }
//            }
    }


}