package com.sd.api.core

import android.graphics.Rect
import com.amap.api.maps.CameraUpdateFactory
import com.amap.api.maps.model.Poi
import com.amap.api.navi.AMapNavi
import com.amap.api.navi.AmapNaviPage
import com.amap.api.navi.AmapNaviParams
import com.amap.api.navi.AmapNaviType
import com.amap.api.navi.AmapPageType
import com.amap.api.navi.model.AMapCalcRouteResult
import com.amap.api.navi.model.AMapNaviPath
import com.amap.api.navi.view.RouteOverLay
import com.minedata.minenavi.map.Route
import com.minedata.minenavi.map.RouteOptions
import com.minedata.minenavi.mapdal.DataPreference
import com.minedata.minenavi.mapdal.LatLng
import com.minedata.minenavi.mapdal.PoiFavorite
import com.minedata.minenavi.navi.NaviSession
import com.minedata.minenavi.navi.NaviSessionParams
import com.minedata.minenavi.navi.RouteBase
import com.minedata.minenavi.navi.RouteCollection
import com.minedata.minenavi.navi.RoutePlan
import com.minedata.minenavi.navi.RouterErrorInfo
import com.minedata.minenavi.util.Tools
import com.sd.api.MAP_TYPE
import com.sd.api.MSDKInitializer
import com.sd.api.UserCtx
import com.sd.api.bean.DriverRouteBean
import com.sd.api.maps.cdata.MSLatLng
import com.sd.api.bean.WayPoi
import com.sd.api.core.basic.OnDriveRoute
import com.sd.api.intfaces.MyAMapNaviListener
import com.sd.api.intfaces.MyMineNaviListener
import com.sd.api.ui.MapReadyView
import com.sd.api.utils.DisplayUtil
import com.amap.api.maps.model.LatLng as ALatLng


/**路劲规划  弃用**/
@Deprecated(
    message = "弃用 直接使用var basicMap = MapFactory.createBasic()\n" +
            "  basicMap.drivingPathPlanning()"
)
private object MSRoutePlans {
    //初始化高德 RouteSearch 对象
//    private var mRouteSearch: RouteSearch? = null
    //初始化高德 导航 对象
    private var mAMapNavi: AMapNavi? = null

    //    private const val ROUTE_TYPE_DRIVE = 2
    //初始化四维导航对象
    private var mNaviSession: NaviSession? = null

    //驾车算路回调对象
    private var driverRouteBean = DriverRouteBean.instance

    //驾车路径规划回调接口
    private var onDriveRoute: OnDriveRoute? = null


    //路径图层返回
//    private var routeOver = RouteOver.instance

    /**
     * 四维保存当前算好的路线
     */
    private var mRoute: Route? = null

    //高德保存当前算好的路线
    private var routeOverlay: RouteOverLay? = null
//    private val routeOverlays: SparseArray<RouteOverLay> = SparseArray<RouteOverLay>()


    /**
     * 添加导航路线规划监听
     * @param onDriveRoute 导航路线回调接口
     */
    fun addPlanLis(onDriveRoute: OnDriveRoute) {
        var context = UserCtx.instance.mContext
        this.onDriveRoute = onDriveRoute

        // 根据地图类型初始化不同的导航引擎
        when (MSDKInitializer.getMapType()) {
            MAP_TYPE.MINE -> {
                mNaviSession = NaviSession.getInstance()
                // 开启语音播报
                mNaviSession?.enableSound(true)
                var naviSessionParams = NaviSessionParams().apply {
                    autoReroute = true
                    autoRemoveRoute = true
//            useMineNaviGPS = true
                }
                mNaviSession!!.init(context, naviSessionParams)

                mNaviSession?.setDataPreference(DataPreference.preferOnline)
                mNaviSession?.addMineNaviListener(myMineNaviListener)
            }

            MAP_TYPE.AMAP -> {
                mAMapNavi = AMapNavi.getInstance(context)
                mAMapNavi!!.addAMapNaviListener(aMapNaviListener)

//                mRouteSearch = RouteSearch(context)
//                mRouteSearch!!.setRouteSearchListener(onRouteSearchListener)
            }
        }
    }


    /**驾车路径规划
     * @param starPoint 起点坐标
     * @param endPoint 终点坐标
     * @param ways     途经点集合
     * @param endName 终点名称（高德可不传）
     * @param startName 起点名称
     */
    fun drivingPathPlanning(
        starPoint: MSLatLng,
        endPoint: MSLatLng,
        ways: List<WayPoi>,
        endName: String = "",
        startName: String = "当前位置"
    ) {
        var context = UserCtx.instance.mContext
        when (MSDKInitializer.getMapType()) {
            MAP_TYPE.MINE -> {
                val starPoint = Tools.latLngToPoint(LatLng(starPoint.lat, starPoint.lng))
                val endPoint = Tools.latLngToPoint(LatLng(endPoint.lat, endPoint.lng))
                var startName = startName
                var endName = endName
                var wayPoints = mutableListOf<PoiFavorite>()
                if (ways.count() > 0) {
                    ways.forEach { wpoi ->
                        var passPoint =
                            Tools.latLngToPoint(LatLng(wpoi.passPoint!!.lat, wpoi.passPoint!!.lng))
                        wayPoints.add(PoiFavorite(passPoint, wpoi.passName))
                    }
                }
                val routePlan = RoutePlan()
                routePlan.setRoutePreference(RoutePlan.RoutePreference.none)
                routePlan.setTransportationType(RoutePlan.TransportationType.car)

                mNaviSession?.calculateDriveRoute(
                    PoiFavorite(starPoint, startName),
                    wayPoints,
                    PoiFavorite(endPoint, endName),
                    routePlan,
                    NaviSession.RouteMethod.multipleResult
                )
            }

            MAP_TYPE.AMAP -> {
                //这是路径规划
                /*      var startLatlng = NaviLatLng(starPoint.lat, starPoint.lng)
                      var startList = listOf<NaviLatLng>(startLatlng)

                      var endLatlng = NaviLatLng(endPoint.lat, endPoint.lng)
                      var endList = listOf<NaviLatLng>(endLatlng)
                      //途经点
                      var wayPoints = mutableListOf<NaviLatLng>()
                      if (ways.count() > 0) {
                          ways.forEach { wpoi ->
                              wayPoints.add(NaviLatLng(wpoi.passPoint!!.lat, wpoi.passPoint!!.lng))
                          }
                      }

                      mAMapNavi?.calculateDriveRoute(
                          startList,
                          endList,
                          wayPoints,
                          PathPlanningStrategy.DRIVING_MULTIPLE_ROUTES_DEFAULT
                      )*/

                //这是导航，直接到高德内置组件
                //途经点
                var poiList = mutableListOf<Poi>()
                if (ways.count() > 0) {
                    ways.forEach { wpoi ->
                        poiList.add(
                            Poi(
                                "鸟巢",
                                ALatLng(wpoi.passPoint!!.lat, wpoi.passPoint!!.lng),
                                ""
                            )
                        )
                    }
                }

                val params = AmapNaviParams(
                    Poi(startName, ALatLng(starPoint.lat, starPoint.lng), ""),
                    poiList,
                    Poi(endName, ALatLng(endPoint.lat, endPoint.lng), ""),
                    AmapNaviType.DRIVER, AmapPageType.ROUTE
                )
                params.setUseInnerVoice(true)
                AmapNaviPage.getInstance()
                    .showRouteActivity(context, params, null)
            }
        }
    }

    /**自定义驾车路线返回*/
 /*   interface OnDriveRoute {
        fun onDriverRoute(driverRouteBean: DriverRouteBean)
    }*/


    /**
     * 绘制规划的路线路径。
     * @param mapReadView 地图视图容器，用于获取当前地图实例。
     * @param driverRB 包含路线信息的数据对象。
     */
    fun drawPlanPath(
        mapReadView: MapReadyView?,
        driverRB: DriverRouteBean
    ) {
        var context = UserCtx.instance.mContext
        when (MSDKInitializer.getMapType()) {
            MAP_TYPE.MINE -> {
                // 移除旧的路线覆盖物
                if (mRoute != null) {
                    mapReadView?.mMineMap?.removeOverlay(mRoute)
                    mRoute = null
                }

                // 获取第一条路线数据并设置路线绘制选项
                var routeBase = driverRB.routeBase
                val options = RouteOptions()
                    .routeBase(routeBase)
                    .colorType(Route.RouteColorType.enrouteTi)
                    .styleClass("DEFAULT")

                // 添加新的路线到地图上，并设置样式和视角适配
                mRoute = mapReadView?.mMineMap?.addRoute(options)
                setRouteOverlayStyle(mRoute, false)
                navEndFitWorldAreaToRect(mapReadView, routeBase)
            }

            MAP_TYPE.AMAP -> {
                // 清除之前的路线覆盖物
                if (routeOverlay != null) {
                    routeOverlay?.removeFromMap()
                    routeOverlay = null
                }

                // 从导航结果中获取路径信息并在高德地图上绘制
                val routeIds = driverRB.aMapCalcRouteResult!!.getRouteid()
                val paths: HashMap<Int, AMapNaviPath> = mAMapNavi!!.getNaviPaths()
                val path: AMapNaviPath? = paths.get(routeIds[0])
                if (path != null) {
                    mapReadView?.aMap?.moveCamera(CameraUpdateFactory.changeTilt(0f))
                    routeOverlay = RouteOverLay(mapReadView?.aMap, path, context)
                    routeOverlay?.setTrafficLine(false)
                    routeOverlay?.addToMap()
                }
            }
        }
    }


//    private fun drawRoutes(
//        routeId: Int,
//        path: AMapNaviPath,
//        mapReadView: MapReadyView?,
//        context: Context
//    ) {
//        mapReadView?.aMap?.moveCamera(CameraUpdateFactory.changeTilt(0f))
//         routeOverLay = RouteOverLay(mapReadView?.aMap, path, context)
//        routeOverLay.setTrafficLine(false)
//        routeOverLay.addToMap()
////        routeOverlays.put(routeId, routeOverLay)
//    }

    private fun setRouteOverlayStyle(route: Route?, isSmallMapRoute: Boolean = false) {
        var routeStyle = "DEFAULT"

        if (isSmallMapRoute) {
            routeStyle += ",small-map"
        }
        route?.selectStyleClass(routeStyle)
    }

    /***将指定的地图上的矩形区域显示到指定的屏幕矩形区域中
     * @param driverRB 驾车路径规划返回
     * ****/
    fun navEndFitWorldAreaToRect(mapReadView: MapReadyView?, mRouteBase: RouteBase?) {
        when (MSDKInitializer.getMapType()) {
            MAP_TYPE.MINE -> {
                if (mRouteBase == null)
                    return
                val rect = Rect(
                    200, 350, DisplayUtil.getScreenWidthPx() - 200,
                    DisplayUtil.getScreenHeightPx() - 200
                )
                // 获取单条道路信息
//                var mRouteBase = driverRB.routeCollection?.routes?.get(0)
                val boundingBox = mRouteBase.getBoundingBox()
                mapReadView?.mMineMap?.fitWorldAreaToRect(boundingBox, rect)
//                    mapReadView?.mMineMap?.setElevation(0f)
            }

            MAP_TYPE.AMAP -> {

            }
        }
    }


    //-------------- 四维 导航监听 --------------------------
    private var myMineNaviListener = object : MyMineNaviListener() {

        private fun getRouteMsg(data: RouterErrorInfo): String {
            var msg = ""
            when (data.errCode) {
                RouterErrorInfo.Type.ComputeFailed -> msg = "路线计算失败"
                RouterErrorInfo.Type.destAuthError -> msg = "终点所在位置数据授权错误"
                RouterErrorInfo.Type.destNoData -> msg = "重点所在位置没有数据"
                RouterErrorInfo.Type.MissingSubfiles -> msg = "缺少途径省份数据"
                RouterErrorInfo.Type.NetworkError -> msg = "网络连接错误"
                RouterErrorInfo.Type.None -> {}
                RouterErrorInfo.Type.NotEnoughMemory -> msg = "没有足够的内存可以使用"
                RouterErrorInfo.Type.oriAuthError -> msg = "起点所在位置数据授权错误"
                RouterErrorInfo.Type.OriDestTooNear -> msg = "起点和终点距离太近"
                RouterErrorInfo.Type.oriNoData -> msg = "起点所在位置没有数据"
                RouterErrorInfo.Type.SetDestFailed -> msg = "设置终点失败"
                RouterErrorInfo.Type.SetOriFailed -> msg = "设置起点失败"
                RouterErrorInfo.Type.waypointAuthError -> msg = "途经点所在位置数据授权错误"
                RouterErrorInfo.Type.waypointNoData -> msg = "途经点所在位置没有数据"
            }
            return msg
        }

        override fun onCalculateRouteSuccess(data: RouteCollection) {
            // 路线规划成功
            driverRouteBean.routeBase = data.routes.get(0)
            onDriveRoute?.onDriverRoute(driverRouteBean)
        }

        override fun onCalculateRouteFailed(data: RouterErrorInfo) {
            // 路线规划失败
            val msg = getRouteMsg(data)
            var a = 0
        }

    }

    //-------------- 高德 导航监听 --------------------------
    private var aMapNaviListener = object : MyAMapNaviListener() {

        override fun onCalculateRouteSuccess(aMapCalcRouteResult: AMapCalcRouteResult?) {
            // 路线规划成功
            driverRouteBean.aMapCalcRouteResult = aMapCalcRouteResult
            onDriveRoute?.onDriverRoute(driverRouteBean)
        }

        override fun onCalculateRouteFailure(result: AMapCalcRouteResult?) {

        }

    }


}