package com.sd.demo.utils

import android.location.Location
import com.minedata.minenavi.addons.DistanceBean


object MyGeoTools {

    /**
     * 计算我的位置到目标的直线距离
     * @param flat 起点纬度
     * @param flng 起点经度
     * @param lat 目标点纬度
     * @param lng 目标点经度
     * @return 距离信息对象，包含格式化后的距离数据
     */
    fun cauMyLocDistance(flat: Double, flng: Double, lat: Double, lng: Double): DistanceBean {
        if (flng == 0.0 || flng == 0.0) {
            return DistanceBean("0","")
        }
        var mUtils = Utils()
        var results = FloatArray(1)
        // 使用Android Location API计算两点间直线距离
        Location.distanceBetween(
            flat,
            flng,
            lat,
            lng,
            results
        )
        var distanceInMeters = results[0]
        // 将距离转换为整数并格式化为距离对象
        val distanceBean: DistanceBean = mUtils.formatDistance(distanceInMeters.toInt(), false)
        return distanceBean
    }

}