package com.sd.demo.ui

import android.os.Bundle
import androidx.activity.enableEdgeToEdge
import androidx.appcompat.app.AppCompatActivity
import com.sd.api.maps.cdata.MSLatLng
import com.sd.api.location.MSLocCb
import com.sd.api.core.MShowMainCarModel
import com.sd.api.ui.MapReadyView
import com.sd.api.location.OnMsGpsLoc
import com.sd.api.ui.MapMultiView.OnMapReadyLis
import com.sd.demo.databinding.ActivityShowCarOnlineBinding

/***在线地推显示小车***/
class ShowCarOnlineActivity : AppCompatActivity() {

    private lateinit var binding: ActivityShowCarOnlineBinding
    var mapReadView: MapReadyView? = null

    //获取接口功能实例
    var mapCoreApi = MapCoreApi.mapCoreApi


    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        enableEdgeToEdge()
        binding = ActivityShowCarOnlineBinding.inflate(layoutInflater)
        setContentView(binding.root)
        binding.mapMultiView.addMapRenderCallback(object : OnMapReadyLis {
            override fun onMapReady(mapReadyView: MapReadyView) {
                this@ShowCarOnlineActivity.mapReadView = mapReadyView
                //地图加载完成后添加小车
                var center = MSLatLng(39.787678, 116.518766)
//                MSMethodAdv.setMapCenter(mapReadView,center.lat, center.lng)
                MShowMainCarModel.addMyLocCarModel(
                    mapReadView,
                    this@ShowCarOnlineActivity,
                    center.lat,
                    center.lng,
                    0f
                )
            }
        })
        //显示小车
        binding.bt1.setOnClickListener {

        }
        //隐藏小车
        binding.bt2.setOnClickListener {

        }

        //设置定位回调
        mapCoreApi.startLoc(object : OnMsGpsLoc {
            override fun onMsGpsLoc(mSLocBean: MSLocCb) {
                //在这里改变小车的位置

            }
        })

    }


}