package com.sd.demo.ui

import android.os.Bundle
import androidx.appcompat.app.AppCompatActivity
import com.sd.api.maps.cdata.MSLatLng
import com.sd.api.ui.MapReadyView
import com.sd.api.maps.MSCalcuMapUtil
import com.sd.api.ui.MapMultiView.OnMapReadyLis
import com.sd.demo.utils.ToastHelper
import com.sd.demo.databinding.ActivityCalculateDistanceBinding

/****两点间距离计算***/
class CalculateDistanceActivity : AppCompatActivity() {

    private lateinit var binding: ActivityCalculateDistanceBinding

    var mapReadView: MapReadyView? = null

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        binding = ActivityCalculateDistanceBinding.inflate(layoutInflater)
        setContentView(binding.root)

        binding.mapMultiView.addMapRenderCallback(object : OnMapReadyLis {
            override fun onMapReady(mapReadyView: MapReadyView) {
                this@CalculateDistanceActivity.mapReadView = mapReadyView
            }
        })

        //计算2点距离
        binding.bt1.setOnClickListener {
            var latLng1=MSLatLng(binding.et1.text.toString().toDouble(),binding.et2.text.toString().toDouble())
            var latLng2=MSLatLng(binding.et3.text.toString().toDouble(),binding.et4.text.toString().toDouble())
//            计算2点距离
            var dis=MSCalcuMapUtil.calculateLineDistance(latLng1,latLng2)
            println("----计算2点距离 = ${dis}米")
            ToastHelper.showShort(this@CalculateDistanceActivity,"距离= ${dis}米")
        }

    }
}