package com.sd.demo.ui

import android.os.Bundle
import androidx.activity.enableEdgeToEdge
import androidx.appcompat.app.AppCompatActivity
import com.amap.api.maps.AMap
import com.sd.demo.LayerManage
import com.sd.demo.databinding.ActivityAmapWmsBinding


class AMapWmsActivity : AppCompatActivity() {
    lateinit var binding: ActivityAmapWmsBinding

    private var layerManage: LayerManage? = null

    private var aMap: AMap? = null


var url: String =
    "https://faw.cuscavp.cn:8443/geoserver/changchun/wms?SERVICE=WMS&VERSION=1.1.1&REQUEST=GetMap&FORMAT=image/png&TRANSPARENT=true"
//var url: String =
//    "https://faw.cuscavp.cn:8443/geoserver/changchun/wms?service=WMS&version=1.1.0&request=GetMap&srs=EPSG:4326&styles="
//var url: String =
//    "http://192.168.59.216/geoserver/wms?LAYERS=zx1&FORMAT=image%2Fpng&TRANSPARENT=TRUE&SERVICE=" +
//            "WMS&VERSION=1.1.0&REQUEST=GetMap&STYLES=&SRS=EPSG:3857&BBOX="
    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        enableEdgeToEdge()
        binding = ActivityAmapWmsBinding.inflate(layoutInflater)
        setContentView(binding.root)
        binding.mapView.onCreate(savedInstanceState)

        aMap = binding.mapView.map

        layerManage = LayerManage(this, aMap)
        layerManage?.addTileOverlay(url)
    }


    override fun onSaveInstanceState(outState: Bundle) {
        super.onSaveInstanceState(outState)
        //在activity执行onSaveInstanceState时执行mapView.onSaveInstanceState (outState)，保存地图当前的状态
        binding.mapView.onSaveInstanceState(outState)
    }


    override fun onResume() {
        super.onResume()
        //在activity执行onResume时执行mapView.onResume ()，重新绘制加载地图
        binding.mapView.onResume()
    }

    override fun onPause() {
        super.onPause()
        //在activity执行onPause时执行mapView.onPause ()，暂停地图的绘制
        binding.mapView.onPause()
    }

    override fun onDestroy() {
        super.onDestroy()
        //在activity执行onDestroy时执行mapView.onDestroy()，销毁地图
        binding.mapView.onDestroy()
    }


}