package com.sd.demo.adapter

//import kotlinx.android.synthetic.main.poi_search_list_item.view.*
import android.content.Context
import android.graphics.Color
import android.text.SpannableString
import android.text.style.ForegroundColorSpan
import android.view.LayoutInflater
import android.view.ViewGroup
import androidx.core.text.set
import androidx.recyclerview.widget.RecyclerView
import com.chad.library.adapter4.BaseQuickAdapter
import com.minedata.minenavi.addons.DistanceBean
import com.sd.api.maps.cdata.PoiSearchRes

import com.sd.demo.utils.MyGeoTools
import com.sd.demo.databinding.PoiSearchListItemBinding


class PoiAdapter  : BaseQuickAdapter<PoiSearchRes, PoiAdapter.PoiSH>() {

    init {
//        addChildClickViewIds(R.id.tv_fouc)
    }

    //用户的搜素关键字
    var usrSearchStr = ""

    override fun onCreateViewHolder(context: Context, parent: ViewGroup, viewType: Int): PoiSH {
        return PoiSH(parent)
    }

    inner class PoiSH(
        parent: ViewGroup,
        val binding: PoiSearchListItemBinding = PoiSearchListItemBinding.inflate(
            LayoutInflater.from(parent.context),
            parent,
            false
        )
    ) : RecyclerView.ViewHolder(binding.root) {
        private var poi_title = binding.poiTitle

        fun show(bean: PoiSearchRes) {
            if (usrSearchStr.isNotEmpty()) {
                var tempStr = bean.title
                var star = tempStr.indexOf(usrSearchStr)
                if (star != -1) {
                    var spannableString = SpannableString(tempStr)
                    var c = ForegroundColorSpan(Color.parseColor("#2C7FFA"))
                    var end = star + usrSearchStr.count()
                    spannableString.set(star..end, c)
                    poi_title.text = spannableString
                } else {
                    poi_title.text = bean.title
                }
            } else {
                poi_title.text = bean.title
            }

            binding.poiDes.text = bean.snippet
//            binding.tvDistan.text=bean.distance.toString()
            if (bean.distance == 0){
                val distanceBean: DistanceBean = MyGeoTools.cauMyLocDistance(0.0,0.0,bean.lat, bean.lng)
                binding.tvDistan.text = "${distanceBean.distanceValue}${distanceBean.distanceUnit}"
            }else{
                binding.tvDistan.text = "${bean.distance}米"
            }

        }

        fun setListener() {
//            tv_fouc.clicks().throttleFirst(1, TimeUnit.SECONDS).subscribe {
//                focusOn(layoutPosition)
//            }
        }
    }

    override fun onBindViewHolder(holder: PoiSH, position: Int, item: PoiSearchRes?) {
        holder.show(item!!)
    }


}