package com.sd.demo

import android.app.Activity
import android.content.Intent
import android.os.Bundle
import androidx.appcompat.app.AppCompatActivity
import com.sd.api.MAP_TYPE
import com.sd.api.MSDKInitializer
import com.sd.api.OnSdkInitCb
import com.sd.demo.adapter.DemoListAdapter
import com.sd.demo.databinding.ActivityMainBinding
import com.sd.demo.ui.CalculateDistanceActivity
import com.sd.demo.ui.ChangeMapCenterAct
import com.sd.demo.ui.DisplayMapActivity
import com.sd.demo.ui.GestureDemo
import com.sd.demo.ui.ShowMyLocLandian
import com.sd.demo.ui.TCircelActivity
import com.sd.demo.ui.TDriveRouteActivity
import com.sd.demo.ui.TGpsActivity
import com.sd.demo.ui.THighMapActivity
import com.sd.demo.ui.TLayersActivity
import com.sd.demo.ui.TLineActivity
import com.sd.demo.ui.TMarkerActivity
import com.sd.demo.ui.TPoiSearchActivity
import com.sd.demo.ui.TPolygonActivity
import com.sd.demo.ui.TReGeocodeActivity


/**
 * Main activity
 *
 * @constructor Create empty Main activity
 */
class MainActivity : AppCompatActivity() {

    private lateinit var binding: ActivityMainBinding

    private var demoListAdapter = DemoListAdapter()


    /**
     * Demo details
     *
     * @property title
     * @property activityClass
     * @constructor Create empty Demo details
     */
    class DemoDetails(
        var title: String,
        var activityClass: Class<out Activity>?
    )

    private var demos = listOf(
        DemoDetails("展示地图", DisplayMapActivity::class.java),
        DemoDetails("切换地图图层", TLayersActivity::class.java),
        DemoDetails("显示定位蓝点", ShowMyLocLandian::class.java),
        DemoDetails("手势控制", GestureDemo::class.java),
        DemoDetails("改变地图中心点,缩放级别", ChangeMapCenterAct::class.java),
        DemoDetails("绘制Marker点", TMarkerActivity::class.java),
        DemoDetails("绘制一条线(实线、虚线)", TLineActivity::class.java),
        DemoDetails("绘制圆形", TCircelActivity::class.java),
        DemoDetails("绘制一个面", TPolygonActivity::class.java),
        DemoDetails("Poi检索（关键字，范围）", TPoiSearchActivity::class.java),
        DemoDetails("逆地理编码", TReGeocodeActivity::class.java),
        DemoDetails("两点间距离计算", CalculateDistanceActivity::class.java),

        DemoDetails("定位，获取我的位置", TGpsActivity::class.java),

        DemoDetails("驾车路线规划(导航)", TDriveRouteActivity::class.java),
//        DemoDetails("定制地图", null),
        DemoDetails("高精地图", THighMapActivity::class.java),

//        DemoDetails("业务相关", null),
//        DemoDetails("在线地图显示小车", ShowCarOnlineActivity::class.java),

//        DemoDetails("测试高德加载WMS", AMapWmsActivity::class.java),

    )


    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        binding = ActivityMainBinding.inflate(layoutInflater)
        setContentView(binding.root)

        initMap()

        binding.demoList.adapter = demoListAdapter
        demoListAdapter.submitList(demos)

        demoListAdapter.setOnItemClickListener { adapter, view, position ->
            val demo = adapter.getItem(position) as DemoDetails
            if (demo.activityClass != null) {
                startActivity(Intent(this, demo.activityClass))
            }
        }

//        binding.sp.onItemSelectedListener=object :AdapterView.OnItemSelectedListener{
//            override fun onItemSelected(
//                parent: AdapterView<*>?,
//                view: View?,
//                position: Int,
//                id: Long
//            ) {
//                var str=parent?.adapter?.getItem(position)
//                println("-------sp str = ${str}")
//                if (str?.equals("四维")==true){
//
//                }else if (str?.equals("高德")==true){
//
//                }
//            }
//
//            override fun onNothingSelected(parent: AdapterView<*>?) {
//
//            }
//        }

    }

    override fun onNewIntent(intent: Intent) {
        super.onNewIntent(intent)
        println("----------MainActivity.onNewIntent")

    }


    /**
     * Init map
     *
     * @param type MINE=四维 AMAP=高德
     */
    fun initMap(type: MAP_TYPE = MAP_TYPE.MINE) {
        MSDKInitializer.initialize(this, type, object : OnSdkInitCb {
            override fun onInitSuccess() {
                println("--------onMapInitSuccess")
            }

            override fun onInitFailed(msg: String) {
                println("--------onInitFailed $msg")
            }
        })
    }




}