package com.sd.demo;

import android.content.Context;

import com.amap.api.maps.AMap;
import com.amap.api.maps.CameraUpdateFactory;
import com.amap.api.maps.model.TileOverlay;
import com.amap.api.maps.model.TileOverlayOptions;
import com.amap.api.maps.model.TileProvider;
import com.amap.api.maps.model.UrlTileProvider;
import com.amap.api.maps.model.LatLng;
import java.net.MalformedURLException;
import java.net.URL;

/**
 * 图层管理
 *
 * @author Hu
 * @date 2024/5/23
 */
public class LayerManage {
    private static final String TAG = "LayerManage";
    private Context mContext;
    private AMap aMap;

    private int titleSize = 256;
    private double initialResolution = 156543.03392804062;//2*Math.PI*6378137/titleSize;//
    private double originShift = 20037508.342789244;//2*Math.PI*6378137/2.0;//
    private TileOverlay tileOverlay;


    /**
     * 构造函数
     */
    public LayerManage(Context context, AMap aMap) {
        mContext = context.getApplicationContext();
        this.aMap = aMap;
    }

    /**
     * 设置地图模式，aMap是地图控制器对象
     *
     * @param type 地图模式
     *             MAP_TYPE_NORMAL：普通地图，值为1；
     *             MAP_TYPE_SATELLITE：卫星地图，值为2；
     *             MAP_TYPE_NIGHT 黑夜地图，夜间模式，值为3；
     *             MAP_TYPE_NAVI 导航模式，值为4;
     *             MAP_TYPE_BUS 公交模式，值为5。
     */

    public void setMapType(int type) {
        aMap.setMapType(type);
    }

    /**
     * 添加图层
     *
     * @param url 构建WMS图层URL
     */
    public TileOverlay addTileOverlay(String url) {
        // 实例化自定义TileProvider
        TileProvider tileProvider = new UrlTileProvider(256, 256) {
            @Override
            public URL getTileUrl(int x, int y, int zoom) {
                // 构建WMS图层URL
                try {
//                    System.out.println(x + "/" + y + "/" + zoom + "=====>" + url + TitleBounds(x, y, zoom));
                    return new URL(url + TitleBounds(x, y, zoom));
                } catch (MalformedURLException e) {
                    e.printStackTrace();
                }
                return null;
            }
        };
        TileOverlayOptions tileOverlayOptions = new TileOverlayOptions().tileProvider(tileProvider);

        // 添加TileOverlay
        tileOverlay = aMap.addTileOverlay(tileOverlayOptions);
//        LatLng latLng = new LatLng(39.80870258484975, 116.5011886304098);
        LatLng latLng = new LatLng(43.838481, 125.143485);//长春中心点坐标
        aMap.moveCamera(CameraUpdateFactory.newLatLngZoom(latLng, 18.0f));
        return tileOverlay;
    }


    /**
     * 移除图层
     */
    public void removeLayer() {
        tileOverlay.remove();
    }


    /**
     * 设置图层可见性
     *
     * @param visibility - true： 表示显示，为默认值； false： 不显示
     */
    public void setLayerVisibility(boolean visibility) {
        if (tileOverlay != null) {
            tileOverlay.setVisible(visibility);
        }
    }

    /**
     * 根据像素、等级算出坐标
     *
     * @param p
     * @param zoom
     * @return
     */
    private double Pixels2Meters(int p, int zoom) {
        return p * Resolution(zoom) - originShift;
    }

    /**
     * 根据瓦片的x/y等级返回瓦片范围
     *
     * @param tx
     * @param ty
     * @param zoom
     * @return
     */
    private String TitleBounds(int tx, int ty, int zoom) {
        double minX = Pixels2Meters(tx * titleSize, zoom);
        double maxY = -Pixels2Meters(ty * titleSize, zoom);
        double maxX = Pixels2Meters((tx + 1) * titleSize, zoom);
        double minY = -Pixels2Meters((ty + 1) * titleSize, zoom);
        //转换成经纬度
//        minX = Meters2Lon(minX);
//        minY = Meters2Lat(minY);
//        maxX = Meters2Lon(maxX);
//        maxY = Meters2Lat(maxY);
        //经纬度转换米
//        minX = Lon2Meter(minX);
//        minY = Lat2Meter(minY);
//        maxX = Lon2Meter(maxX);
//        maxY = Lat2Meter(maxY);
        //坐标转换工具类构造方法 GPS( WGS-84) 转 为高德地图需要的坐标
//        CoordinateConverter converter = new CoordinateConverter(context);
//        converter.from(CoordinateConverter.CoordType.GPS);
//        converter.coord(new LatLng(minY, minX));
//        LatLng min = converter.convert();
//        converter.coord(new LatLng(maxY, maxX));
//        LatLng max = converter.convert();
//        minX = Lon2Meter(-min.longitude + 2 * minX);
//        minY = Lat2Meter(-min.latitude + 2 * minY);
//        maxX = Lon2Meter(-max.longitude + 2 * maxX);
//        maxY = Lat2Meter(-max.latitude + 2 * maxY);
        return minX + "," + minY + "," + maxX + "," + maxY + "&WIDTH=256&HEIGHT=256";
    }

    /**
     * 计算分辨率
     *
     * @param zoom
     * @return
     */
    private double Resolution(int zoom) {
        return initialResolution / (Math.pow(2, zoom));
    }

    /**
     * X米转经纬度
     */
    private double Meters2Lon(double mx) {
        double lon = (mx / originShift) * 180.0;
        return lon;
    }

    /**
     * Y米转经纬度
     */
    private double Meters2Lat(double my) {
        double lat = (my / originShift) * 180.0;
        lat = 180.0 / Math.PI * (2 * Math.atan(Math.exp(lat * Math.PI / 180.0)) - Math.PI / 2.0);
        return lat;
    }

    /**
     * X经纬度转米
     */
    private double Lon2Meter(double lon) {
        double mx = lon * originShift / 180.0;
        return mx;
    }

    /**
     * Y经纬度转米
     */
    private double Lat2Meter(double lat) {
        double my = Math.log(Math.tan((90 + lat) * Math.PI / 360.0)) / (Math.PI / 180.0
        );
        my = my * originShift / 180.0;
        return my;
    }
}
