/*
 * Decompiled with CFR 0.152.
 */
package com.autonavi.amap.mapcore;

import android.graphics.Point;
import com.autonavi.amap.mapcore.DPoint;

public class VirtualEarthProjection {
    public static final int MAXZOOMLEVEL = 20;
    public static final int PIXELS_PER_TILE = 256;
    public static final double MIN_LATITUDE = -85.0511287798;
    public static final double MAX_LATITUDE = 85.0511287798;
    public static final double MIN_LONGITUDE = -360.0;
    public static final double MAX_LONGITUDE = 360.0;
    public static final int EARTH_RADIUS_IN_METERS = 6378137;
    public static final int TILE_SPLIT_LEVEL = 0;
    private static final int KMA_MAX_MAP_SIZE = 0x10000000;
    private static final double K_EARTH_CIRCLE = 4.0075016E7;
    private static final double K_EARTH_CIRCLE_2 = 2.0037508E7;
    public static final double EARTH_CIRCUMFERENCE_IN_METERS = 4.007501668557849E7;

    public static double clip(double d2, double d3, double d4) {
        return Math.min(Math.max(d2, d3), d4);
    }

    public static Point latLongToPixels(int n2, int n3, int n4) {
        return VirtualEarthProjection.latLongToPixels((double)n3 / 3600000.0, (double)n2 / 3600000.0, n4);
    }

    private static double radToDeg(double d2) {
        return d2 * 57.29577951308232;
    }

    private static double degToRad(double d2) {
        return d2 * (Math.PI / 180);
    }

    public static void latLongToPixels(double d2, double d3, int n2, Point point) {
        d2 = VirtualEarthProjection.clip(d2, -85.0511287798, 85.0511287798);
        d3 = VirtualEarthProjection.clip(d3, -360.0, 360.0);
        double d4 = 6378137.0 * VirtualEarthProjection.degToRad(d3);
        double d5 = Math.sin(VirtualEarthProjection.degToRad(d2));
        double d6 = Math.log((1.0 + d5) / (1.0 - d5));
        double d7 = 6378137.0 * d6 / 2.0;
        double d8 = (2.0037508E7 + d4) / 0.14929106831550598;
        double d9 = (2.0037508E7 - d7) / 0.14929106831550598;
        point.x = (int)d8;
        point.y = (int)d9;
    }

    public static Point latLongToPixels(double d2, double d3, int n2) {
        Point point = new Point();
        VirtualEarthProjection.latLongToPixels(d2, d3, n2, point);
        return point;
    }

    public static DPoint latLongToPixelsDouble(double d2, double d3, int n2) {
        DPoint dPoint = new DPoint();
        d2 = VirtualEarthProjection.clip(d2, -85.0511287798, 85.0511287798);
        d3 = VirtualEarthProjection.clip(d3, -360.0, 360.0);
        double d4 = 6378137.0 * VirtualEarthProjection.degToRad(d3);
        double d5 = Math.sin(VirtualEarthProjection.degToRad(d2));
        double d6 = Math.log((1.0 + d5) / (1.0 - d5));
        double d7 = 6378137.0 * d6 / 2.0;
        double d8 = (2.0037508E7 + d4) / 0.14929106831550598;
        double d9 = (2.0037508E7 - d7) / 0.14929106831550598;
        dPoint.x = d8;
        dPoint.y = d9;
        return dPoint;
    }

    public static DPoint pixelsToLatLong(long l2, long l3, int n2) {
        DPoint dPoint = DPoint.obtain();
        double d2 = (double)l2 * 0.14929106831550598 - 2.0037508E7;
        double d3 = 2.0037508E7 - (double)l3 * 0.14929106831550598;
        double d4 = d2 / 6378137.0;
        dPoint.x = VirtualEarthProjection.radToDeg(d4);
        double d5 = Math.exp(d3 / 6378137.0 * 2.0);
        double d6 = (d5 - 1.0) / (1.0 + d5);
        dPoint.y = VirtualEarthProjection.radToDeg(Math.asin(d6));
        return dPoint;
    }

    public static DPoint pixelsToLatLong(double d2, double d3, int n2) {
        DPoint dPoint = DPoint.obtain();
        double d4 = d2 * 0.14929106831550598 - 2.0037508E7;
        double d5 = 2.0037508E7 - d3 * 0.14929106831550598;
        double d6 = d4 / 6378137.0;
        dPoint.x = VirtualEarthProjection.radToDeg(d6);
        double d7 = Math.exp(d5 / 6378137.0 * 2.0);
        double d8 = (d7 - 1.0) / (1.0 + d7);
        dPoint.y = VirtualEarthProjection.radToDeg(Math.asin(d8));
        return dPoint;
    }
}

